/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.xgboost.matrix;

import ai.h2o.xgboost4j.java.util.BigDenseMatrix;
import hex.tree.xgboost.matrix.DenseMatrixFactory;
import hex.tree.xgboost.matrix.MatrixLoader;
import hex.tree.xgboost.matrix.SparseMatrix;
import hex.tree.xgboost.matrix.SparseMatrixDimensions;
import hex.tree.xgboost.matrix.SparseMatrixFactory;
import hex.tree.xgboost.task.XGBoostUploadMatrixTask;
import java.util.HashMap;
import java.util.Map;
import water.Key;

public class RemoteMatrixLoader
extends MatrixLoader {
    private static final Map<String, RemoteMatrix> REGISTRY = new HashMap<String, RemoteMatrix>();
    private final Key<?> modelKey;

    public static void initSparse(String key, SparseMatrixDimensions dims) {
        RemoteSparseMatrix m = new RemoteSparseMatrix(dims);
        REGISTRY.put(key, m);
    }

    public static void sparseChunk(String key, XGBoostUploadMatrixTask.SparseMatrixChunk chunk) {
        int i;
        RemoteSparseMatrix m = (RemoteSparseMatrix)REGISTRY.get(key);
        long nonZeroCount = m.dims._precedingNonZeroElementsCounts[chunk.id];
        int rwRow = m.dims._precedingRowCounts[chunk.id];
        SparseMatrixFactory.NestedArrayPointer rowHeaderPointer = new SparseMatrixFactory.NestedArrayPointer(rwRow);
        SparseMatrixFactory.NestedArrayPointer dataPointer = new SparseMatrixFactory.NestedArrayPointer(nonZeroCount);
        for (i = 0; i < chunk.rowHeader.length; ++i) {
            rowHeaderPointer.setAndIncrement(m.matrix._rowHeaders, chunk.rowHeader[i]);
        }
        for (i = 0; i < chunk.data.length; ++i) {
            dataPointer.set(m.matrix._sparseData, chunk.data[i]);
            dataPointer.set(m.matrix._colIndices, chunk.colIndices[i]);
            dataPointer.increment();
        }
    }

    public static void initDense(String key, XGBoostUploadMatrixTask.DenseMatrixDimensions dims) {
        RemoteDenseMatrix m = new RemoteDenseMatrix(dims);
        REGISTRY.put(key, m);
    }

    public static void denseChunk(String key, XGBoostUploadMatrixTask.DenseMatrixChunk chunk) {
        RemoteDenseMatrix m = (RemoteDenseMatrix)REGISTRY.get(key);
        for (long i = 0L; i < (long)chunk.data.length; ++i) {
            m.matrix.set(i + (long)(m.dims.rowOffsets[chunk.id] * m.dims.cols), chunk.data[(int)i]);
        }
    }

    public static void matrixData(String key, XGBoostUploadMatrixTask.MatrixData data) {
        RemoteMatrixLoader.REGISTRY.get((Object)key).data = data;
    }

    public static void cleanup(String key) {
        REGISTRY.remove(key);
    }

    public RemoteMatrixLoader(Key<?> modelKey) {
        this.modelKey = modelKey;
    }

    @Override
    public MatrixLoader.DMatrixProvider makeLocalTrainMatrix() {
        return REGISTRY.remove(RemoteMatrixLoader.trainMatrixKey(this.modelKey)).make();
    }

    public static String trainMatrixKey(Key<?> modelKey) {
        return modelKey.toString() + "_train";
    }

    @Override
    public boolean hasValidationFrame() {
        return REGISTRY.containsKey(RemoteMatrixLoader.validMatrixKey(this.modelKey));
    }

    @Override
    public MatrixLoader.DMatrixProvider makeLocalValidMatrix() {
        return REGISTRY.remove(RemoteMatrixLoader.validMatrixKey(this.modelKey)).make();
    }

    public static String validMatrixKey(Key<?> modelKey) {
        return modelKey.toString() + "_valid";
    }

    static class RemoteDenseMatrix
    extends RemoteMatrix {
        final XGBoostUploadMatrixTask.DenseMatrixDimensions dims;
        final BigDenseMatrix matrix;

        RemoteDenseMatrix(XGBoostUploadMatrixTask.DenseMatrixDimensions dims) {
            this.dims = dims;
            this.matrix = new BigDenseMatrix(dims.rows, dims.cols);
        }

        @Override
        MatrixLoader.DMatrixProvider make() {
            return new DenseMatrixFactory.DenseDMatrixProvider(this.data.actualRows, this.data.resp, this.data.weights, this.data.offsets, this.matrix);
        }
    }

    static class RemoteSparseMatrix
    extends RemoteMatrix {
        final SparseMatrixDimensions dims;
        final SparseMatrix matrix;

        RemoteSparseMatrix(SparseMatrixDimensions dims) {
            this.dims = dims;
            this.matrix = SparseMatrixFactory.allocateCSRMatrix(dims);
        }

        @Override
        MatrixLoader.DMatrixProvider make() {
            return SparseMatrixFactory.toDMatrix(this.matrix, this.dims, this.data.actualRows, this.data.shape, this.data.resp, this.data.weights, this.data.offsets);
        }
    }

    static abstract class RemoteMatrix {
        XGBoostUploadMatrixTask.MatrixData data;

        RemoteMatrix() {
        }

        abstract MatrixLoader.DMatrixProvider make();
    }
}

