/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deepwater;

import deepwater.backends.BackendParams;
import deepwater.backends.RuntimeOptions;
import deepwater.datasets.ImageDataSet;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.deepwater.DeepwaterMojoModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

public class DeepwaterMojoReader
extends ModelMojoReader<DeepwaterMojoModel> {
    public String getModelName() {
        return "Deep Water";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readModelData() throws IOException {
        try {
            ((DeepwaterMojoModel)this._model)._network = this.readblob("model_network");
            ((DeepwaterMojoModel)this._model)._parameters = this.readblob("model_params");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ((DeepwaterMojoModel)this._model)._backend = DeepwaterMojoModel.createDeepWaterBackend((String)this.readkv("backend"));
        if (((DeepwaterMojoModel)this._model)._backend == null) {
            throw new IllegalArgumentException("Couldn't instantiate the Deep Water backend.");
        }
        ((DeepwaterMojoModel)this._model)._problem_type = (String)this.readkv("problem_type");
        ((DeepwaterMojoModel)this._model)._mini_batch_size = (Integer)this.readkv("mini_batch_size");
        ((DeepwaterMojoModel)this._model)._height = (Integer)this.readkv("height");
        ((DeepwaterMojoModel)this._model)._width = (Integer)this.readkv("width");
        ((DeepwaterMojoModel)this._model)._channels = (Integer)this.readkv("channels");
        ((DeepwaterMojoModel)this._model)._nums = (Integer)this.readkv("nums");
        ((DeepwaterMojoModel)this._model)._cats = (Integer)this.readkv("cats");
        ((DeepwaterMojoModel)this._model)._catOffsets = (int[])this.readkv("cat_offsets");
        ((DeepwaterMojoModel)this._model)._normMul = (double[])this.readkv("norm_mul");
        ((DeepwaterMojoModel)this._model)._normSub = (double[])this.readkv("norm_sub");
        ((DeepwaterMojoModel)this._model)._normRespMul = (double[])this.readkv("norm_resp_mul");
        ((DeepwaterMojoModel)this._model)._normRespSub = (double[])this.readkv("norm_resp_sub");
        ((DeepwaterMojoModel)this._model)._useAllFactorLevels = (Boolean)this.readkv("use_all_factor_levels");
        ((DeepwaterMojoModel)this._model)._imageDataSet = new ImageDataSet(((DeepwaterMojoModel)this._model)._width, ((DeepwaterMojoModel)this._model)._height, ((DeepwaterMojoModel)this._model)._channels, ((DeepwaterMojoModel)this._model)._nclasses);
        ((DeepwaterMojoModel)this._model)._opts = new RuntimeOptions();
        ((DeepwaterMojoModel)this._model)._opts.setSeed(0L);
        ((DeepwaterMojoModel)this._model)._opts.setUseGPU(((Boolean)this.readkv("gpu")).booleanValue());
        ((DeepwaterMojoModel)this._model)._opts.setDeviceID((int[])this.readkv("device_id"));
        ((DeepwaterMojoModel)this._model)._backendParams = new BackendParams();
        ((DeepwaterMojoModel)this._model)._backendParams.set("mini_batch_size", (Object)1);
        File file = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString() + ".json");
        try {
            FileOutputStream os = new FileOutputStream(file.toString());
            os.write(((DeepwaterMojoModel)this._model)._network);
            os.close();
            ((DeepwaterMojoModel)this._model)._model = ((DeepwaterMojoModel)this._model)._backend.buildNet(((DeepwaterMojoModel)this._model)._imageDataSet, ((DeepwaterMojoModel)this._model)._opts, ((DeepwaterMojoModel)this._model)._backendParams, ((DeepwaterMojoModel)this._model)._nclasses, file.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                ((DeepwaterMojoModel)this._model)._backend.deleteSavedModel(file.toString());
            }
        }
        try {
            byte[] meanBlob = this.readblob("mean_image_file");
            File meanFile = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString() + ".mean");
            try {
                FileOutputStream os = new FileOutputStream(meanFile.toString());
                os.write(meanBlob);
                os.close();
                ((DeepwaterMojoModel)this._model)._imageDataSet.setMeanData(((DeepwaterMojoModel)this._model)._backend.loadMeanImage(((DeepwaterMojoModel)this._model)._model, meanFile.toString()));
                ((DeepwaterMojoModel)this._model)._meanImageData = ((DeepwaterMojoModel)this._model)._imageDataSet.getMeanData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (meanFile != null) {
                    meanFile.delete();
                }
            }
        }
        catch (IOException meanFile) {
            // empty catch block
        }
        file = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        try {
            ((DeepwaterMojoModel)this._model)._backend.writeBytes(file, ((DeepwaterMojoModel)this._model)._parameters);
            ((DeepwaterMojoModel)this._model)._backend.loadParam(((DeepwaterMojoModel)this._model)._model, file.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (file != null) {
                ((DeepwaterMojoModel)this._model)._backend.deleteSavedParam(file.toString());
            }
        }
    }

    protected DeepwaterMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new DeepwaterMojoModel(columns, domains, responseColumn);
    }

    public String mojoVersion() {
        return "1.00";
    }
}

