/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.HashMap;
import java.util.Map;

public class MathBinaryTransform
extends MojoTransform {
    MathBinaryFunction _function;
    boolean _isLeftCol;
    boolean _isRightCol;
    double _constValue;

    MathBinaryTransform(int[] iindices, int[] oindices, MathBinaryFunction function, boolean isLeftCol, boolean isRightCol, double constValue) {
        super(iindices, oindices);
        this._function = function;
        this._isLeftCol = isLeftCol;
        this._isRightCol = isRightCol;
        this._constValue = constValue;
    }

    public void transform(MojoFrame frame) {
        if (!this._isLeftCol) {
            double[] values = (double[])frame.getColumnData(this.iindices[0]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(this._constValue, values[i]);
            }
        } else if (!this._isRightCol) {
            double[] values = (double[])frame.getColumnData(this.iindices[0]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(values[i], this._constValue);
            }
        } else {
            double[] left = (double[])frame.getColumnData(this.iindices[0]);
            double[] right = (double[])frame.getColumnData(this.iindices[1]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(left[i], right[i]);
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, MathBinaryFunction> _supportedFunctions = new HashMap<String, MathBinaryFunction>(){
            {
                this.put("&", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.and(l, r);
                    }
                });
                this.put("&&", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.and(l, r);
                    }
                });
                this.put("|", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.or(l, r);
                    }
                });
                this.put("||", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.or(l, r);
                    }
                });
                this.put("==", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.isEqual(l, r) ? 1.0 : 0.0;
                    }
                });
                this.put("!=", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Factory.isEqual(l, r) ? 0.0 : 1.0;
                    }
                });
                this.put("<=", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l <= r ? 1.0 : 0.0;
                    }
                });
                this.put("<", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l < r ? 1.0 : 0.0;
                    }
                });
                this.put(">=", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l >= r ? 1.0 : 0.0;
                    }
                });
                this.put(">", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l > r ? 1.0 : 0.0;
                    }
                });
                this.put("intDiv", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return (int)r == 0 ? Double.NaN : (double)((int)l / (int)r);
                    }
                });
                this.put("%/%", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return (int)(l / r);
                    }
                });
                this.put("%", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l % r;
                    }
                });
                this.put("%%", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l % r;
                    }
                });
                this.put("*", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l * r;
                    }
                });
                this.put("/", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l / r;
                    }
                });
                this.put("+", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l + r;
                    }
                });
                this.put("-", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return l - r;
                    }
                });
                this.put("^", new MathBinaryFunction(){

                    @Override
                    public double call(double l, double r) {
                        return Math.pow(l, r);
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.MathBinaryTransform";

        private static boolean isEqual(double l, double r) {
            if (Double.isNaN(l) && Double.isNaN(r)) {
                return true;
            }
            double ulpLeft = Math.ulp(l);
            double ulpRight = Math.ulp(r);
            double smallUlp = Math.min(ulpLeft, ulpRight);
            double absDiff = Math.abs(l - r);
            return absDiff <= smallUlp;
        }

        private static double and(double l, double r) {
            return l == 0.0 || r == 0.0 ? 0.0 : (Double.isNaN(l) || Double.isNaN(r) ? Double.NaN : 1.0);
        }

        private static double or(double l, double r) {
            return l == 1.0 || r == 1.0 ? 1.0 : (Double.isNaN(l) || Double.isNaN(r) ? Double.NaN : 0.0);
        }

        public static MathBinaryFunction getFunction(String functionName) {
            MathBinaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported unary math transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            Boolean isLeftCol = (Boolean)params.get("isLeftCol");
            Boolean isRightCol = (Boolean)params.get("isRightCol");
            double constValue = 0.0;
            if (!isLeftCol.booleanValue() || !isRightCol.booleanValue()) {
                constValue = (Double)params.get("constValue");
            }
            MathBinaryFunction function = Factory.getFunction(functionName);
            return new MathBinaryTransform(iindcies, oindices, function, isLeftCol, isRightCol, constValue);
        }
    }

    static interface MathBinaryFunction {
        public double call(double var1, double var3);
    }
}

