/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class MathUnaryTransform
extends MojoTransform {
    MathUnaryFunction _function;

    MathUnaryTransform(int[] iindices, int[] oindices, MathUnaryFunction function) {
        super(iindices, oindices);
        this._function = function;
    }

    public void transform(MojoFrame frame) {
        double[] a = (double[])frame.getColumnData(this.iindices[0]);
        double[] o = (double[])frame.getColumnData(this.oindices[0]);
        int nrows = frame.getNrows();
        for (int i = 0; i < nrows; ++i) {
            o[i] = this._function.call(a[i]);
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, MathUnaryFunction> _supportedFunctions = new HashMap<String, MathUnaryFunction>(){
            {
                this.put("abs", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.abs(value);
                    }
                });
                this.put("acos", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.acos(value);
                    }
                });
                this.put("acosh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return FastMath.acosh((double)value);
                    }
                });
                this.put("asin", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.asin(value);
                    }
                });
                this.put("asinh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return FastMath.asinh((double)value);
                    }
                });
                this.put("atan", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.atan(value);
                    }
                });
                this.put("atanh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return FastMath.atanh((double)value);
                    }
                });
                this.put("ceiling", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.ceil(value);
                    }
                });
                this.put("cos", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.cos(value);
                    }
                });
                this.put("cosh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.cosh(value);
                    }
                });
                this.put("cospi", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.cos(Math.PI * value);
                    }
                });
                this.put("digamma", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Double.isNaN(value) ? Double.NaN : Gamma.digamma((double)value);
                    }
                });
                this.put("exp", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.exp(value);
                    }
                });
                this.put("expm1", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.expm1(value);
                    }
                });
                this.put("floor", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.floor(value);
                    }
                });
                this.put("gamma", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Gamma.gamma((double)value);
                    }
                });
                this.put("lgamma", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Gamma.logGamma((double)value);
                    }
                });
                this.put("log", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.log(value);
                    }
                });
                this.put("log1p", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.log1p(value);
                    }
                });
                this.put("log2", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.log(value) / Math.log(2.0);
                    }
                });
                this.put("log10", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.log10(value);
                    }
                });
                this.put("none", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return value;
                    }
                });
                this.put("not", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Double.isNaN(value) ? Double.NaN : (value == 0.0 ? 1.0 : 0.0);
                    }
                });
                this.put("sign", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.signum(value);
                    }
                });
                this.put("sin", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.sin(value);
                    }
                });
                this.put("sinh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.sinh(value);
                    }
                });
                this.put("sinpi", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.sin(Math.PI * value);
                    }
                });
                this.put("sqrt", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.sqrt(value);
                    }
                });
                this.put("tan", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.tan(value);
                    }
                });
                this.put("tanh", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.tanh(value);
                    }
                });
                this.put("tanpi", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Math.tan(Math.PI * value);
                    }
                });
                this.put("trigamma", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return Double.isNaN(value) ? Double.NaN : Gamma.trigamma((double)value);
                    }
                });
                this.put("trunc", new MathUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(double value) {
                        return value >= 0.0 ? Math.floor(value) : Math.ceil(value);
                    }
                });
                this.put("round", new MathUnaryFunction(){
                    double _digits = Double.NaN;
                    double _powerOf10 = Double.NaN;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object digitsObj = params.get("rightArg");
                        if (digitsObj == null) {
                            throw new IllegalArgumentException("The 'digits' param is not passed to 'round' function!");
                        }
                        this._digits = (Double)digitsObj;
                        if ((double)((int)this._digits) != this._digits) {
                            this._digits = Math.round(this._digits);
                        }
                        this._powerOf10 = (int)Math.pow(10.0, (int)this._digits);
                    }

                    @Override
                    public double call(double x) {
                        if (Double.isNaN(x)) {
                            return x;
                        }
                        double sgn = x < 0.0 ? -1.0 : 1.0;
                        x = Math.abs(x);
                        return sgn * (this._digits == 0.0 ? (x % 1.0 > 0.5 || x % 1.0 == 0.5 && Math.floor(x) % 2.0 != 0.0 ? Math.ceil(x) : Math.floor(x)) : Math.floor(x * this._powerOf10 + 0.5) / this._powerOf10);
                    }
                });
                this.put("signif", new MathUnaryFunction(){
                    double _digits = Double.NaN;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object digitsObj = params.get("rightArg");
                        if (digitsObj == null) {
                            throw new IllegalArgumentException("The 'digits' param is not passed to 'signif' function!");
                        }
                        this._digits = (Double)digitsObj;
                        if (this._digits < 1.0) {
                            this._digits = 1.0;
                        }
                        if ((double)((int)this._digits) != this._digits) {
                            this._digits = Math.round(this._digits);
                        }
                    }

                    @Override
                    public double call(double x) {
                        if (Double.isNaN(x)) {
                            return x;
                        }
                        BigDecimal bd = new BigDecimal(x);
                        bd = bd.round(new MathContext((int)this._digits, RoundingMode.HALF_EVEN));
                        return bd.doubleValue();
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.MathUnaryTransform";

        public static MathUnaryFunction getFunction(String functionName) {
            MathUnaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported unary math transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            MathUnaryFunction function = Factory.getFunction(functionName);
            function.initialize(params);
            return new MathUnaryTransform(iindcies, oindices, function);
        }
    }

    static interface MathUnaryFunction {
        public void initialize(Map<String, Object> var1);

        public double call(double var1);
    }
}

