/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import hex.genmodel.mojopipeline.parsing.ParameterParser;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringGrepTransform
extends MojoTransform {
    Pattern _pattern = null;
    Boolean _invert = null;

    StringGrepTransform(int[] iindices, int[] oindices, Pattern pattern, Boolean invert) {
        super(iindices, oindices);
        this._pattern = pattern;
        this._invert = invert;
    }

    public void transform(MojoFrame frame) {
        String[] a = (String[])frame.getColumnData(this.iindices[0]);
        double[] o = (double[])frame.getColumnData(this.oindices[0]);
        Matcher matcher = this._pattern.matcher("");
        int nrows = frame.getNrows();
        for (int i = 0; i < nrows; ++i) {
            if (a[i] == null) {
                o[i] = this._invert != false ? 1.0 : 0.0;
                continue;
            }
            matcher.reset(a[i]);
            o[i] = matcher.find() != this._invert.booleanValue() ? 1.0 : 0.0;
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.StringGrepTransform";

        public static boolean functionExists(String functionName) {
            return functionName.equals("grep");
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            Object ignoreCaseObj = params.get("ignore_case");
            if (ignoreCaseObj == null) {
                throw new IllegalArgumentException("The 'ignore_case' param is not passed to 'grep' function!");
            }
            boolean ignoreCase = ParameterParser.paramValueToBoolean(ignoreCaseObj);
            int flags = ignoreCase ? 66 : 0;
            Object invertObj = params.get("invert");
            if (invertObj == null) {
                throw new IllegalArgumentException("The 'invert' param is not passed to 'grep' function!");
            }
            boolean invert = ParameterParser.paramValueToBoolean(invertObj);
            Object outputLogicalObj = params.get("output_logical");
            if (outputLogicalObj == null) {
                throw new IllegalArgumentException("The 'output_logical' param is not passed to 'grep' function!");
            }
            boolean outputLogical = ParameterParser.paramValueToBoolean(outputLogicalObj);
            if (!outputLogical) {
                throw new IllegalArgumentException("The 'grep' operation in MOJO supports just logical output!");
            }
            Object patternObj = params.get("regex");
            if (patternObj == null) {
                throw new IllegalArgumentException("The 'pattern' param is not passed to 'grep' function!");
            }
            String stringPattern = (String)patternObj;
            Pattern pattern = Pattern.compile(stringPattern, flags);
            return new StringGrepTransform(iindcies, oindices, pattern, invert);
        }
    }
}

