/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.HashMap;
import java.util.Map;
import no.priv.garshol.duke.Comparator;
import water.util.comparison.string.StringComparatorFactory;

public class StringPropertiesBinaryTransform
extends MojoTransform {
    StringPropertiesBinaryFunction _function;
    boolean _isLeftCol;
    boolean _isRightCol;
    String _constValue;

    StringPropertiesBinaryTransform(int[] iindices, int[] oindices, StringPropertiesBinaryFunction function, boolean isLeftCol, boolean isRightCol, String constValue) {
        super(iindices, oindices);
        this._function = function;
        this._isLeftCol = isLeftCol;
        this._isRightCol = isRightCol;
        this._constValue = constValue;
    }

    public void transform(MojoFrame frame) {
        if (!this._isLeftCol) {
            String[] values = (String[])frame.getColumnData(this.iindices[0]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(this._constValue, values[i]);
            }
        } else if (!this._isRightCol) {
            String[] values = (String[])frame.getColumnData(this.iindices[0]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(values[i], this._constValue);
            }
        } else {
            String[] left = (String[])frame.getColumnData(this.iindices[0]);
            String[] right = (String[])frame.getColumnData(this.iindices[1]);
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = this._function.call(left[i], right[i]);
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, StringPropertiesBinaryFunction> _supportedFunctions = new HashMap<String, StringPropertiesBinaryFunction>(){
            {
                this.put("strDistance", new StringPropertiesBinaryFunction(){
                    Comparator _comparator = null;
                    boolean _compareEmpty = false;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object measureObj = params.get("measure");
                        if (measureObj == null) {
                            throw new IllegalArgumentException("The 'measure' param is not passed to 'strDistance' function!");
                        }
                        String measure = (String)measureObj;
                        this._comparator = StringComparatorFactory.makeComparator((String)measure);
                        Object compareEmptyObj = params.get("compare_empty");
                        if (compareEmptyObj == null) {
                            throw new IllegalArgumentException("The 'compare_empty' param is not passed to 'strDistance' function!");
                        }
                        this._compareEmpty = Boolean.parseBoolean((String)compareEmptyObj);
                    }

                    @Override
                    public double call(String left, String right) {
                        if (!this._compareEmpty && (left.isEmpty() || right.isEmpty())) {
                            return Double.NaN;
                        }
                        return this._comparator.compare(left, right);
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.StringPropertiesBinaryTransform";

        public static StringPropertiesBinaryFunction getFunction(String functionName) {
            StringPropertiesBinaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported binary string properties transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            Boolean isLeftCol = (Boolean)params.get("isLeftCol");
            Boolean isRightCol = (Boolean)params.get("isRightCol");
            String constValue = null;
            if (!isLeftCol.booleanValue() || !isRightCol.booleanValue()) {
                constValue = (String)params.get("constValue");
            }
            StringPropertiesBinaryFunction function = Factory.getFunction(functionName);
            function.initialize(params);
            return new StringPropertiesBinaryTransform(iindcies, oindices, function, isLeftCol, isRightCol, constValue);
        }
    }

    static interface StringPropertiesBinaryFunction {
        public void initialize(Map<String, Object> var1);

        public double call(String var1, String var2);
    }
}

