/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class StringPropertiesUnaryTransform
extends MojoTransform {
    StringPropertiesUnaryFunction _function;

    StringPropertiesUnaryTransform(int[] iindices, int[] oindices, StringPropertiesUnaryFunction function) {
        super(iindices, oindices);
        this._function = function;
    }

    public void transform(MojoFrame frame) {
        String[] a = (String[])frame.getColumnData(this.iindices[0]);
        double[] o = (double[])frame.getColumnData(this.oindices[0]);
        int nrows = frame.getNrows();
        for (int i = 0; i < nrows; ++i) {
            o[i] = a[i] == null ? null : Double.valueOf(this._function.call(a[i]));
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, StringPropertiesUnaryFunction> _supportedFunctions = new HashMap<String, StringPropertiesUnaryFunction>(){
            {
                this.put("countmatches", new StringPropertiesUnaryFunction(){
                    String[] _pattern = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object patternObj = params.get("pattern");
                        if (patternObj == null) {
                            throw new IllegalArgumentException("The 'pattern' param is not passed to 'countmatches' function!");
                        }
                        if (!(patternObj instanceof String)) {
                            throw new IllegalArgumentException(String.format("The type '%s' of 'pattern' param is not supported.", patternObj.getClass().getName()));
                        }
                        this._pattern = ((String)patternObj).split("`````");
                    }

                    @Override
                    public double call(String value) {
                        int count = 0;
                        for (String word : this._pattern) {
                            count += StringUtils.countMatches((String)value, (String)word);
                        }
                        return count;
                    }
                });
                this.put("num_valid_substrings", new StringPropertiesUnaryFunction(){
                    HashSet<String> _words = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object wordsObj = params.get("words");
                        if (wordsObj == null) {
                            throw new IllegalArgumentException("The 'words' param is not passed to 'num_valid_substrings' function!");
                        }
                        String wordsPath = (String)wordsObj;
                        try {
                            this._words = new HashSet(FileUtils.readLines((File)new File(wordsPath)));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public double call(String value) {
                        int count = 0;
                        int N = value.length();
                        for (int i = 0; i < N - 1; ++i) {
                            for (int j = i + 2; j < N + 1; ++j) {
                                if (!this._words.contains(value.substring(i, j))) continue;
                                ++count;
                            }
                        }
                        return count;
                    }
                });
                this.put("entropy", new StringPropertiesUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(String value) {
                        HashMap<Character, Integer> freq = new HashMap<Character, Integer>();
                        for (int i = 0; i < value.length(); ++i) {
                            char c = value.charAt(i);
                            Integer count = (Integer)freq.get(Character.valueOf(c));
                            if (count == null) {
                                freq.put(Character.valueOf(c), 1);
                                continue;
                            }
                            freq.put(Character.valueOf(c), count + 1);
                        }
                        double sume = 0.0;
                        int N = value.length();
                        Iterator iterator = freq.keySet().iterator();
                        while (iterator.hasNext()) {
                            char c = ((Character)iterator.next()).charValue();
                            double n = ((Integer)freq.get(Character.valueOf(c))).intValue();
                            sume += -n / (double)N * Math.log(n / (double)N) / Math.log(2.0);
                        }
                        return sume;
                    }
                });
                this.put("strlen", new StringPropertiesUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(String value) {
                        return value.length();
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.StringPropertiesUnaryTransform";

        public static StringPropertiesUnaryFunction getFunction(String functionName) {
            StringPropertiesUnaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported unary string transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            StringPropertiesUnaryFunction function = Factory.getFunction(functionName);
            function.initialize(params);
            return new StringPropertiesUnaryTransform(iindcies, oindices, function);
        }
    }

    static interface StringPropertiesUnaryFunction {
        public void initialize(Map<String, Object> var1);

        public double call(String var1);
    }
}

