/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.Map;

public class StringSplitTransform
extends MojoTransform {
    String _regex = null;
    int _numberOfOutputCols;

    StringSplitTransform(int[] iindices, int[] oindices, String regex) {
        super(iindices, oindices);
        this._regex = regex;
        this._numberOfOutputCols = oindices.length;
    }

    public void transform(MojoFrame frame) {
        String[] a = (String[])frame.getColumnData(this.iindices[0]);
        String[][] outputs = new String[this._numberOfOutputCols][];
        for (int j = 0; j < this._numberOfOutputCols; ++j) {
            outputs[j] = (String[])frame.getColumnData(this.oindices[j]);
        }
        int nrows = frame.getNrows();
        for (int i = 0; i < nrows; ++i) {
            if (a[i] == null) continue;
            String[] split = a[i].split(this._regex);
            int nCol = Math.min(this._numberOfOutputCols, split.length);
            for (int j = 0; j < nCol; ++j) {
                outputs[j][i] = split[j];
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.StringSplitTransform";

        public static boolean functionExists(String functionName) {
            return functionName.equals("strsplit");
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            Object regexObj = params.get("split");
            if (regexObj == null) {
                throw new IllegalArgumentException("The 'split' param is not passed to 'strsplit' function!");
            }
            String regex = (String)regexObj;
            return new StringSplitTransform(iindcies, oindices, regex);
        }
    }
}

