/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import hex.genmodel.mojopipeline.parsing.ParameterParser;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class StringUnaryTransform
extends MojoTransform {
    StringUnaryFunction _function;

    StringUnaryTransform(int[] iindices, int[] oindices, StringUnaryFunction function) {
        super(iindices, oindices);
        this._function = function;
    }

    public void transform(MojoFrame frame) {
        String[] a = (String[])frame.getColumnData(this.iindices[0]);
        String[] o = (String[])frame.getColumnData(this.oindices[0]);
        int nrows = frame.getNrows();
        for (int i = 0; i < nrows; ++i) {
            o[i] = a[i] == null ? null : this._function.call(a[i]);
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, StringUnaryFunction> _supportedFunctions = new HashMap<String, StringUnaryFunction>(){
            {
                this.put("lstrip", new StringUnaryFunction(){
                    private String _set = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object setObj = params.get("set");
                        if (setObj == null) {
                            throw new IllegalArgumentException("The 'set' param is not passed to 'lstrip' function!");
                        }
                        this._set = (String)setObj;
                    }

                    @Override
                    public String call(String value) {
                        return StringUtils.stripStart((String)value, (String)this._set);
                    }
                });
                this.put("rstrip", new StringUnaryFunction(){
                    private String _set = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object setObj = params.get("set");
                        if (setObj == null) {
                            throw new IllegalArgumentException("The 'set' param is not passed to 'rstrip' function!");
                        }
                        this._set = (String)setObj;
                    }

                    @Override
                    public String call(String value) {
                        return StringUtils.stripEnd((String)value, (String)this._set);
                    }
                });
                this.put("replaceall", new StringUnaryFunction(){
                    Pattern _pattern = null;
                    String _replacement = null;
                    Boolean _ignoreCase = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object patternObj = params.get("pattern");
                        if (patternObj == null) {
                            throw new IllegalArgumentException("The 'pattern' param is not passed to 'replaceall' function!");
                        }
                        String stringPattern = (String)patternObj;
                        this._pattern = Pattern.compile(stringPattern);
                        Object replacementObj = params.get("replacement");
                        if (replacementObj == null) {
                            throw new IllegalArgumentException("The 'replacement' param is not passed to 'replaceall' function!");
                        }
                        this._replacement = (String)replacementObj;
                        Object ignoreCaseObj = params.get("ignore_case");
                        if (ignoreCaseObj == null) {
                            throw new IllegalArgumentException("The 'ignore_case' param is not passed to 'replaceall' function!");
                        }
                        this._ignoreCase = ParameterParser.paramValueToBoolean(ignoreCaseObj);
                    }

                    @Override
                    public String call(String value) {
                        if (this._ignoreCase.booleanValue()) {
                            return this._pattern.matcher(value.toLowerCase(Locale.ENGLISH)).replaceAll(this._replacement);
                        }
                        return this._pattern.matcher(value).replaceAll(this._replacement);
                    }
                });
                this.put("replacefirst", new StringUnaryFunction(){
                    Pattern _pattern = null;
                    String _replacement = null;
                    Boolean _ignoreCase = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object patternObj = params.get("pattern");
                        if (patternObj == null) {
                            throw new IllegalArgumentException("The 'pattern' param is not passed to 'replacefirst' function!");
                        }
                        String stringPattern = (String)patternObj;
                        this._pattern = Pattern.compile(stringPattern);
                        Object replacementObj = params.get("replacement");
                        if (replacementObj == null) {
                            throw new IllegalArgumentException("The 'replacement' param is not passed to 'replacefirst' function!");
                        }
                        this._replacement = (String)replacementObj;
                        Object ignoreCaseObj = params.get("ignore_case");
                        if (ignoreCaseObj == null) {
                            throw new IllegalArgumentException("The 'ignore_case' param is not passed to 'replacefirst' function!");
                        }
                        this._ignoreCase = ParameterParser.paramValueToBoolean(ignoreCaseObj);
                    }

                    @Override
                    public String call(String value) {
                        if (this._ignoreCase.booleanValue()) {
                            return this._pattern.matcher(value.toLowerCase(Locale.ENGLISH)).replaceFirst(this._replacement);
                        }
                        return this._pattern.matcher(value).replaceFirst(this._replacement);
                    }
                });
                this.put("substring", new StringUnaryFunction(){
                    private int _startIndex = 0;
                    private int _endIndex = Integer.MAX_VALUE;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object endIndexObj;
                        Object startIndexObj = params.get("startIndex");
                        if (startIndexObj != null) {
                            this._startIndex = ((Double)startIndexObj).intValue();
                            if (this._startIndex < 0) {
                                this._startIndex = 0;
                            }
                        }
                        if ((endIndexObj = params.get("endIndex")) != null) {
                            this._endIndex = ((Double)endIndexObj).intValue();
                        }
                    }

                    @Override
                    public String call(String value) {
                        return value.substring(this._startIndex < value.length() ? this._startIndex : value.length(), this._endIndex < value.length() ? this._endIndex : value.length());
                    }
                });
                this.put("tolower", new StringUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public String call(String value) {
                        return value.toLowerCase(Locale.ENGLISH);
                    }
                });
                this.put("toupper", new StringUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public String call(String value) {
                        return value.toUpperCase(Locale.ENGLISH);
                    }
                });
                this.put("trim", new StringUnaryFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public String call(String value) {
                        return value.trim();
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.StringUnaryFunction";

        public static StringUnaryFunction getFunction(String functionName) {
            StringUnaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported unary string transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            StringUnaryFunction function = Factory.getFunction(functionName);
            function.initialize(params);
            return new StringUnaryTransform(iindcies, oindices, function);
        }
    }

    static interface StringUnaryFunction {
        public void initialize(Map<String, Object> var1);

        public String call(String var1);
    }
}

