/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;

public class TimeUnaryTransform
extends MojoTransform {
    TimeUnaryFunction _function;
    DateTimeZone _timeZone;

    TimeUnaryTransform(int[] iindices, int[] oindices, TimeUnaryFunction function, DateTimeZone timeZone) {
        super(iindices, oindices);
        this._function = function;
        this._timeZone = timeZone;
    }

    public void transform(MojoFrame frame) {
        double[] a = (double[])frame.getColumnData(this.iindices[0]);
        String[] factors = this._function.factors();
        MutableDateTime dataTime = new MutableDateTime(0L, this._timeZone);
        if (factors == null) {
            double[] o = (double[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                if (Double.isNaN(a[i])) {
                    o[i] = Double.NaN;
                    continue;
                }
                dataTime.setMillis((long)a[i]);
                o[i] = this._function.call(dataTime);
            }
        } else {
            String[] o = (String[])frame.getColumnData(this.oindices[0]);
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                if (Double.isNaN(a[i])) {
                    o[i] = null;
                    continue;
                }
                dataTime.setMillis((long)a[i]);
                o[i] = factors[(int)this._function.call(dataTime)];
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, TimeUnaryFunction> _supportedFunctions = new HashMap<String, TimeUnaryFunction>(){
            {
                this.put("day", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getDayOfMonth();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("dayOfWeek", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getDayOfWeek() - 1;
                    }

                    @Override
                    public String[] factors() {
                        return new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
                    }
                });
                this.put("hour", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getHourOfDay();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("millis", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getMillisOfSecond();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("minute", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getMinuteOfHour();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("month", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getMonthOfYear();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("second", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getSecondOfMinute();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("week", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getWeekOfWeekyear();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
                this.put("year", new TimeUnaryFunction(){

                    @Override
                    public double call(MutableDateTime value) {
                        return value.getYear();
                    }

                    @Override
                    public String[] factors() {
                        return null;
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.TimeUnaryTransform";

        public static TimeUnaryFunction getFunction(String functionName) {
            TimeUnaryFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported unary time transformation.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            TimeUnaryFunction function = Factory.getFunction(functionName);
            String timeZoneId = (String)params.get("timezone");
            DateTimeZone timeZone = DateTimeZone.forID((String)timeZoneId);
            return new TimeUnaryTransform(iindcies, oindices, function, timeZone);
        }
    }

    static interface TimeUnaryFunction {
        public double call(MutableDateTime var1);

        public String[] factors();
    }
}

