/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import water.util.ParseTime;

public class ToNumericConversion
extends MojoTransform {
    ToNumericConversionFunction _function;

    ToNumericConversion(int[] iindices, int[] oindices, ToNumericConversionFunction function) {
        super(iindices, oindices);
        this._function = function;
    }

    public void transform(MojoFrame frame) {
        Object input = frame.getColumnData(this.iindices[0]);
        double[] o = (double[])frame.getColumnData(this.oindices[0]);
        if (input instanceof double[]) {
            double[] a = (double[])input;
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = a[i];
            }
        } else {
            String[] a = (String[])input;
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = a[i] == null ? Double.NaN : this._function.call(a[i]);
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final HashMap<String, ToNumericConversionFunction> _supportedFunctions = new HashMap<String, ToNumericConversionFunction>(){
            {
                this.put("as.numeric", new ToNumericConversionFunction(){

                    @Override
                    public void initialize(Map<String, Object> params) {
                    }

                    @Override
                    public double call(String value) {
                        return NumberUtils.toDouble((String)value, (double)Double.NaN);
                    }
                });
                this.put("as.Date", new ToNumericConversionFunction(){
                    DateTimeFormatter _formatter = null;

                    @Override
                    public void initialize(Map<String, Object> params) {
                        Object formatObj = params.get("format");
                        if (formatObj == null) {
                            throw new IllegalArgumentException("The 'format' param is not passed to 'as.Date' function!");
                        }
                        String format = (String)formatObj;
                        Object timezoneObj = params.get("timezone");
                        if (formatObj == null) {
                            throw new IllegalArgumentException("The 'timezone' param is not passed to 'as.Date' function!");
                        }
                        DateTimeZone timeZoneId = DateTimeZone.forID((String)((String)timezoneObj));
                        this._formatter = ParseTime.forStrptimePattern((String)format).withZone(timeZoneId);
                    }

                    @Override
                    public double call(String value) {
                        try {
                            return DateTime.parse((String)value, (DateTimeFormatter)this._formatter).getMillis();
                        }
                        catch (IllegalArgumentException e) {
                            return Double.NaN;
                        }
                    }
                });
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.ToNumericConversion";

        public static ToNumericConversionFunction getFunction(String functionName) {
            ToNumericConversionFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported conversion to numeric.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            ToNumericConversionFunction function = Factory.getFunction(functionName);
            function.initialize(params);
            return new ToNumericConversion(iindcies, oindices, function);
        }
    }

    static interface ToNumericConversionFunction {
        public void initialize(Map<String, Object> var1);

        public double call(String var1);
    }
}

