/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.mojopipeline.transformers;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory;
import java.util.HashMap;
import java.util.Map;

public class ToStringConversion
extends MojoTransform {
    ToStringConversionFunction _function;

    ToStringConversion(int[] iindices, int[] oindices, ToStringConversionFunction function) {
        super(iindices, oindices);
        this._function = function;
    }

    public void transform(MojoFrame frame) {
        Object input = frame.getColumnData(this.iindices[0]);
        String[] o = (String[])frame.getColumnData(this.oindices[0]);
        if (input instanceof String[]) {
            String[] a = (String[])input;
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = a[i];
            }
        } else {
            double[] a = (double[])input;
            int nrows = frame.getNrows();
            for (int i = 0; i < nrows; ++i) {
                o[i] = Double.isNaN(a[i]) ? null : this._function.call(a[i]);
            }
        }
    }

    public static class Factory
    implements MojoTransformBuilderFactory {
        private static final ToStringConversionFunction _defaultConversionFunction = new ToStringConversionFunction(){

            @Override
            public String call(double value) {
                return Double.valueOf(value).toString();
            }
        };
        private static final HashMap<String, ToStringConversionFunction> _supportedFunctions = new HashMap<String, ToStringConversionFunction>(){
            {
                this.put("as.factor", _defaultConversionFunction);
                this.put("as.character", _defaultConversionFunction);
            }
        };
        public static final String TRANSFORMER_ID = "hex.genmodel.mojopipeline.transformers.ToStringConversion";

        public static ToStringConversionFunction getFunction(String functionName) {
            ToStringConversionFunction function = _supportedFunctions.get(functionName);
            if (function == null) {
                throw new UnsupportedOperationException(String.format("The function '%s' is not supported conversion to string.", functionName));
            }
            return function;
        }

        public static boolean functionExists(String functionName) {
            return _supportedFunctions.containsKey(functionName);
        }

        public String transformerName() {
            return TRANSFORMER_ID;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindcies, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String functionName = (String)params.get("function");
            ToStringConversionFunction function = Factory.getFunction(functionName);
            return new ToStringConversion(iindcies, oindices, function);
        }
    }

    static interface ToStringConversionFunction {
        public String call(double var1);
    }
}

