/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import ml.dmlc.xgboost4j.java.NativeLibrary;
import ml.dmlc.xgboost4j.java.NativeLibraryLoaderChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String nativePath = "../lib/";
    private static final String nativeResourcePath = "/lib/";
    private static final String[] libNames = new String[]{"xgboost4j"};
    public static final String MINIMAL_LIB_SUFFIX = "";
    private static final boolean ORIGINAL_LOAD_PATH = Boolean.valueOf(System.getProperty("sys.xgboost.jni.original", "false"));
    private static final NativeLibraryLoaderChain loader = NativeLibraryLoaderChain.loaderChain(NativeLibrary.nativeLibrary("xgboost4j_gpu"), NativeLibrary.nativeLibrary("xgboost4j"));

    public static synchronized void initXGBoost() throws IOException {
        if (ORIGINAL_LOAD_PATH) {
            if (!initialized) {
                for (String libName : libNames) {
                    NativeLibLoader.smartLoad(libName);
                }
                initialized = true;
            }
        } else if (!loader.isLoaded()) {
            NativeLibLoader.addNativeDir(nativePath);
            loader.load();
        }
    }

    public static synchronized String getLoadedLibraryName() throws IOException {
        NativeLibLoader.initXGBoost();
        if (loader.getSuccesfullyLoaded() != null) {
            return loader.getSuccesfullyLoaded().getName();
        }
        throw new IOException("No binary library found!");
    }

    public static synchronized String getLoadedLibrarySuffix() throws IOException {
        String libName = NativeLibLoader.getLoadedLibraryName();
        int lastIndex = -1;
        if (libName != null && (lastIndex = libName.lastIndexOf(95)) >= 0) {
            return libName.substring(lastIndex + 1);
        }
        return MINIMAL_LIB_SUFFIX;
    }

    private static void loadLibraryFromJar(String path) throws IOException, IllegalArgumentException {
        String temp = NativeLibLoader.createTempFileFromResource(path);
        System.load(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createTempFileFromResource(String path) throws IOException, IllegalArgumentException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = MINIMAL_LIB_SUFFIX;
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        InputStream is = NativeLibLoader.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("File " + path + " was not found inside JAR.");
        }
        FileOutputStream os = new FileOutputStream(temp);
        try {
            int readBytes;
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)os).close();
            is.close();
        }
        return temp.getAbsolutePath();
    }

    private static void smartLoad(String libName) throws IOException {
        NativeLibLoader.addNativeDir(nativePath);
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                String libraryFromJar = nativeResourcePath + System.mapLibraryName(libName);
                NativeLibLoader.loadLibraryFromJar(libraryFromJar);
            }
            catch (IOException ioe) {
                logger.error((Object)"failed to load library from both native path and jar");
                throw ioe;
            }
        }
    }

    private static void addNativeDir(String libPath) throws IOException {
        try {
            String[] paths;
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            for (String path : paths = (String[])field.get(null)) {
                if (!libPath.equals(path)) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = libPath;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage());
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)e.getMessage());
            throw new IOException("Failed to get field handle to set library path");
        }
    }
}

