/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import ml.dmlc.xgboost4j.java.Loadable;
import ml.dmlc.xgboost4j.java.Platform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibrary
implements Loadable {
    private static final Log logger = LogFactory.getLog(NativeLibrary.class);
    private final String name;
    private final String version;
    private final ClassLoader classLoader;
    private final Platform platform;
    private boolean loaded = false;

    public static Loadable nativeLibrary(String name) {
        return new NativeLibrary(name);
    }

    public static Loadable nativeLibrary(String name, ClassLoader classLoader) {
        return new NativeLibrary(name, null, classLoader);
    }

    public NativeLibrary(String name) {
        this(name, null, NativeLibrary.class.getClassLoader());
    }

    public NativeLibrary(String name, String version, ClassLoader classLoader) {
        this.name = name;
        this.version = version;
        this.classLoader = classLoader;
        this.platform = Platform.geOSType();
    }

    @Override
    public synchronized boolean load() throws IOException {
        if (!this.loaded) {
            this.doLoad();
            this.loaded = true;
        }
        return this.loaded;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    private void doLoad() throws IOException {
        String libName = this.getName();
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                this.extractAndLoad(this.getPlatformLibraryPath(), this.getSimpleLibraryPath());
            }
            catch (IOException ioe) {
                logger.warn((Object)"Failed to load library from both native path and jar!");
                throw ioe;
            }
        }
    }

    protected String getPlatformLibraryPath() {
        return String.format("%s/%s/%s", this.getResourcePrefix(), this.platform.getPlatform(), this.platform.getPlatformLibName(this.getName()));
    }

    protected String getSimpleLibraryPath() {
        return String.format("%s/%s", this.getResourcePrefix(), this.platform.getPlatformLibName(this.getName()));
    }

    protected String getResourcePrefix() {
        return "lib";
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void extractAndLoad(String ... libPaths) throws IOException {
        Throwable lastException = null;
        for (String libPath : libPaths) {
            try {
                lastException = null;
                File temp = NativeLibrary.extract(libPath, this.getClassLoader());
                System.load(temp.getAbsolutePath());
                logger.info((Object)("Loaded library from " + libPath + " (" + temp.getAbsolutePath() + ")"));
                break;
            }
            catch (IOException | UnsatisfiedLinkError e) {
                logger.warn((Object)("Cannot load library from path " + libPath));
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new IOException(lastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(String libPath, ClassLoader classLoader) throws IOException, IllegalArgumentException {
        String filename = libPath.substring(libPath.lastIndexOf(47) + 1);
        int lastDotIdx = filename.lastIndexOf(46);
        String prefix = "";
        String suffix = null;
        if (lastDotIdx >= 0 && lastDotIdx < filename.length() - 1) {
            prefix = filename.substring(0, lastDotIdx);
            suffix = filename.substring(lastDotIdx);
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        InputStream is = classLoader.getResourceAsStream(libPath);
        if (is == null) {
            throw new FileNotFoundException("File " + libPath + " was not found inside JAR.");
        }
        try {
            Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            is.close();
        }
        return temp;
    }

    public String toString() {
        return String.format("%s (%s)", this.getName(), this.getPlatformLibraryPath());
    }
}

