/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import ml.dmlc.xgboost4j.java.IRabitTracker;
import ml.dmlc.xgboost4j.java.NativeLibLoader;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RabitTracker
implements IRabitTracker {
    private static final Log logger = LogFactory.getLog(RabitTracker.class);
    private static String tracker_py = null;
    private Map<String, String> envs = new HashMap<String, String>();
    private int numWorkers;
    private AtomicReference<Process> trackerProcess = new AtomicReference();

    private static void initTrackerPy() throws IOException {
        try {
            tracker_py = NativeLibLoader.createTempFileFromResource("/tracker.py");
        }
        catch (IOException ioe) {
            logger.trace((Object)"cannot access tracker python script");
            throw ioe;
        }
    }

    public RabitTracker(int numWorkers) throws XGBoostError {
        if (numWorkers < 1) {
            throw new XGBoostError("numWorkers must be greater equal to one");
        }
        this.numWorkers = numWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        logger.error((Object)"Uncaught exception thrown by worker:", e);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            logger.error((Object)ex);
        }
        finally {
            this.trackerProcess.get().destroy();
        }
    }

    @Override
    public Map<String, String> getWorkerEnvs() {
        return this.envs;
    }

    private void loadEnvs(InputStream ins) throws IOException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
            assert (reader.readLine().trim().equals("DMLC_TRACKER_ENV_START"));
            while ((line = reader.readLine()) != null && !line.trim().equals("DMLC_TRACKER_ENV_END")) {
                String[] sep = line.split("=");
                if (sep.length != 2) continue;
                this.envs.put(sep[0], sep[1]);
            }
            reader.close();
        }
        catch (IOException ioe) {
            logger.error((Object)"cannot get runtime configuration from tracker process");
            ioe.printStackTrace();
            throw ioe;
        }
    }

    private boolean startTrackerProcess() {
        try {
            this.trackerProcess.set(Runtime.getRuntime().exec("python " + tracker_py + " --log-level=DEBUG --num-workers=" + String.valueOf(this.numWorkers)));
            this.loadEnvs(this.trackerProcess.get().getInputStream());
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private void stop() {
        if (this.trackerProcess.get() != null) {
            this.trackerProcess.get().destroy();
        }
    }

    @Override
    public boolean start(long timeout) {
        if (timeout > 0L) {
            logger.warn((Object)"Python RabitTracker does not support timeout. The tracker will wait for all workers to connect indefinitely, unless it is interrupted manually. Use the Scala RabitTracker for timeout support.");
        }
        if (this.startTrackerProcess()) {
            logger.debug((Object)("Tracker started, with env=" + this.envs.toString()));
            System.out.println("Tracker started, with env=" + this.envs.toString());
            Thread logger_thread = new Thread(new TrackerProcessLogger());
            logger_thread.setDaemon(true);
            logger_thread.start();
            return true;
        }
        logger.error((Object)"FAULT: failed to start tracker process");
        this.stop();
        return false;
    }

    @Override
    public int waitFor(long timeout) {
        if (timeout > 0L) {
            logger.warn((Object)"Python RabitTracker does not support timeout. The tracker will wait for either all workers to finish tasks and send shutdown signal, or manual interruptions. Use the Scala RabitTracker for timeout support.");
        }
        try {
            this.trackerProcess.get().waitFor();
            int returnVal = this.trackerProcess.get().exitValue();
            logger.info((Object)("Tracker Process ends with exit code " + returnVal));
            this.stop();
            return returnVal;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.error((Object)"the RabitTracker thread is terminated unexpectedly");
            return IRabitTracker.TrackerStatus.INTERRUPTED.getStatusCode();
        }
    }

    static {
        try {
            RabitTracker.initTrackerPy();
        }
        catch (IOException ex) {
            logger.error((Object)"load tracker library failed.");
            logger.error((Object)ex);
        }
    }

    private class TrackerProcessLogger
    implements Runnable {
        private TrackerProcessLogger() {
        }

        @Override
        public void run() {
            Log trackerProcessLogger = LogFactory.getLog(TrackerProcessLogger.class);
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Process)RabitTracker.this.trackerProcess.get()).getErrorStream()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    trackerProcessLogger.info((Object)line);
                }
                ((Process)RabitTracker.this.trackerProcess.get()).waitFor();
                trackerProcessLogger.info((Object)("Tracker Process ends with exit code " + ((Process)RabitTracker.this.trackerProcess.get()).exitValue()));
            }
            catch (IOException ex) {
                trackerProcessLogger.error((Object)ex.toString());
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                logger.error((Object)"the RabitTracker thread is terminated unexpectedly");
            }
        }
    }
}

