/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public final class XGBoostMojoModel
extends MojoModel {
    Booster _booster;
    public int _nums;
    public int _cats;
    public int[] _catOffsets;
    public boolean _useAllFactorLevels;
    public boolean _sparse;

    public XGBoostMojoModel(String[] columns, String[][] domains) {
        super(columns, domains);
    }

    public XGBoostMojoModel(String[] columns, String[][] domains, Booster _booster, int _nums, int _cats, int[] _catOffsets, boolean _useAllFactorLevels, boolean _sparse) {
        super(columns, domains);
        this._booster = _booster;
        this._nums = _nums;
        this._cats = _cats;
        this._catOffsets = _catOffsets;
        this._useAllFactorLevels = _useAllFactorLevels;
        this._sparse = _sparse;
    }

    public double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    public final double[] score0(double[] doubles, double offset, double[] preds) {
        return XGBoostMojoModel.score0(doubles, offset, preds, this._booster, this._nums, this._cats, this._catOffsets, this._useAllFactorLevels, this._nclasses, this._priorClassDistrib, this._defaultThreshold, this._sparse);
    }

    public static final double[] score0(double[] doubles, double offset, double[] preds, Booster _booster, int _nums, int _cats, int[] _catOffsets, boolean _useAllFactorLevels, int nclasses, double[] _priorClassDistrib, double _defaultThreshold, boolean _sparse) {
        if (offset != 0.0) {
            throw new UnsupportedOperationException("Unsupported: offset != 0");
        }
        int cats = _catOffsets == null ? 0 : _catOffsets[_cats];
        float[] floats = new float[_nums + cats];
        GenModel.setInput((double[])doubles, (float[])floats, (int)_nums, (int)_cats, (int[])_catOffsets, null, null, (boolean)_useAllFactorLevels, (boolean)_sparse);
        float[][] out = null;
        try {
            DMatrix dmat = new DMatrix(floats, 1, floats.length, _sparse ? 0.0f : Float.NaN);
            out = _booster.predict(dmat);
        }
        catch (XGBoostError xgBoostError) {
            xgBoostError.printStackTrace();
        }
        if (nclasses > 2) {
            for (int i = 0; i < out[0].length; ++i) {
                preds[1 + i] = out[0][i];
            }
            preds[0] = GenModel.getPrediction((double[])preds, (double[])_priorClassDistrib, (double[])doubles, (double)_defaultThreshold);
        } else if (nclasses == 2) {
            preds[1] = 1.0f - out[0][0];
            preds[2] = out[0][0];
            preds[0] = GenModel.getPrediction((double[])preds, (double[])_priorClassDistrib, (double[])doubles, (double)_defaultThreshold);
        } else {
            preds[0] = out[0][0];
        }
        return preds;
    }
}

