/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.IOException;
import java.util.ArrayList;
import ml.dmlc.xgboost4j.java.Loadable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NativeLibraryLoaderChain
implements Loadable {
    private static final Log logger = LogFactory.getLog(NativeLibraryLoaderChain.class);
    private final Loadable[] nativeLibs;
    private Loadable succesfullyLoaded = null;
    private boolean loaded = false;

    private NativeLibraryLoaderChain(Loadable[] libs) {
        assert (libs != null) : "Argument `libs` cannot be null.";
        this.nativeLibs = libs;
    }

    @Override
    public synchronized boolean load() throws IOException {
        if (!this.isLoaded()) {
            ArrayList<IOException> exs = new ArrayList<IOException>();
            for (Loadable lib : this.nativeLibs) {
                try {
                    this.loaded = lib.load();
                    if (!this.loaded) continue;
                    this.succesfullyLoaded = lib;
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)("Cannot load library: " + lib.toString()));
                    exs.add(e);
                }
            }
            if (!this.isLoaded() && !exs.isEmpty()) {
                throw new IOException((Throwable)exs.get(exs.size() - 1));
            }
        }
        return this.isLoaded();
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public String getName() {
        return "nativeLibrartLoaderChain";
    }

    public static NativeLibraryLoaderChain loaderChain(Loadable ... libs) {
        return new NativeLibraryLoaderChain(libs);
    }

    public Loadable getSuccesfullyLoaded() {
        return this.succesfullyLoaded;
    }
}

