/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.IOException;
import java.io.InputStream;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;

public class BoosterHelper {
    public static Booster loadModel(String modelPath) throws XGBoostError {
        return Booster.loadModel(modelPath);
    }

    public static Booster loadModel(InputStream in) throws XGBoostError, IOException {
        return Booster.loadModel(in);
    }

    public static void dispose(Object ... xgbObjects) throws IllegalStateException {
        Exception firstException = null;
        for (Object xgbObject : xgbObjects) {
            if (xgbObject == null) continue;
            if (xgbObject instanceof Booster) {
                try {
                    ((Booster)xgbObject).dispose();
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
                continue;
            }
            if (xgbObject instanceof DMatrix) {
                try {
                    ((DMatrix)xgbObject).dispose();
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
                continue;
            }
            assert (false) : "Unsupported XGBoost object type: " + xgbObject.getClass();
        }
        if (firstException != null) {
            throw new IllegalStateException("We were unable to free-up xgboost memory. This could indicate a memory leak and it can lead to H2O instability.", firstException);
        }
    }
}

