/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deepwater.caffe.nano;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface Deepwater {
    public static final int Create = 0;
    public static final int Train = 1;
    public static final int Predict = 2;
    public static final int SaveGraph = 3;
    public static final int Save = 4;
    public static final int Load = 5;
    public static final int Success = 10;
    public static final int Failure = 11;

    public static final class Saved
    extends MessageNano {
        private static volatile Saved[] _emptyArray;
        public String solver;
        public int[] inputShape;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Saved[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Saved[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Saved() {
            this.clear();
        }

        public Saved clear() {
            this.solver = "";
            this.inputShape = WireFormatNano.EMPTY_INT_ARRAY;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (!this.solver.equals("")) {
                output.writeString(1, this.solver);
            }
            if (this.inputShape != null && this.inputShape.length > 0) {
                for (int i = 0; i < this.inputShape.length; ++i) {
                    output.writeInt32(2, this.inputShape[i]);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (!this.solver.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(1, this.solver);
            }
            if (this.inputShape != null && this.inputShape.length > 0) {
                int dataSize = 0;
                for (int i = 0; i < this.inputShape.length; ++i) {
                    int element = this.inputShape[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.inputShape.length;
            }
            return size;
        }

        @Override
        public Saved mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 10: {
                        this.solver = input.readString();
                        continue block6;
                    }
                    case 16: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 16);
                        int i = this.inputShape == null ? 0 : this.inputShape.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.inputShape, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.inputShape = newArray;
                        continue block6;
                    }
                    case 18: 
                }
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int arrayLength = 0;
                int startPos = input.getPosition();
                while (input.getBytesUntilLimit() > 0) {
                    input.readInt32();
                    ++arrayLength;
                }
                input.rewindToPosition(startPos);
                int i = this.inputShape == null ? 0 : this.inputShape.length;
                int[] newArray = new int[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.inputShape, 0, newArray, 0, i);
                }
                while (i < newArray.length) {
                    newArray[i] = input.readInt32();
                    ++i;
                }
                this.inputShape = newArray;
                input.popLimit(limit);
            }
        }

        public static Saved parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new Saved(), data);
        }

        public static Saved parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Saved().mergeFrom(input);
        }
    }

    public static final class Cmd
    extends MessageNano {
        private static volatile Cmd[] _emptyArray;
        public int type;
        public String graph;
        public int[] inputShape;
        public String solverType;
        public float learningRate;
        public float momentum;
        public long randomSeed;
        public boolean useGpu;
        public int[] sizes;
        public String[] types;
        public double[] dropoutRatios;
        public byte[][] data;
        public String path;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Cmd[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Cmd[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Cmd() {
            this.clear();
        }

        public Cmd clear() {
            this.type = 0;
            this.graph = "";
            this.inputShape = WireFormatNano.EMPTY_INT_ARRAY;
            this.solverType = "";
            this.learningRate = 0.0f;
            this.momentum = 0.0f;
            this.randomSeed = 0L;
            this.useGpu = false;
            this.sizes = WireFormatNano.EMPTY_INT_ARRAY;
            this.types = WireFormatNano.EMPTY_STRING_ARRAY;
            this.dropoutRatios = WireFormatNano.EMPTY_DOUBLE_ARRAY;
            this.data = WireFormatNano.EMPTY_BYTES_ARRAY;
            this.path = "";
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            Object element;
            int i;
            if (this.type != 0) {
                output.writeInt32(1, this.type);
            }
            if (!this.graph.equals("")) {
                output.writeString(100, this.graph);
            }
            if (this.inputShape != null && this.inputShape.length > 0) {
                for (i = 0; i < this.inputShape.length; ++i) {
                    output.writeInt32(101, this.inputShape[i]);
                }
            }
            if (!this.solverType.equals("")) {
                output.writeString(102, this.solverType);
            }
            if (Float.floatToIntBits(this.learningRate) != Float.floatToIntBits(0.0f)) {
                output.writeFloat(103, this.learningRate);
            }
            if (Float.floatToIntBits(this.momentum) != Float.floatToIntBits(0.0f)) {
                output.writeFloat(104, this.momentum);
            }
            if (this.randomSeed != 0L) {
                output.writeInt64(105, this.randomSeed);
            }
            if (this.useGpu) {
                output.writeBool(106, this.useGpu);
            }
            if (this.sizes != null && this.sizes.length > 0) {
                for (i = 0; i < this.sizes.length; ++i) {
                    output.writeInt32(201, this.sizes[i]);
                }
            }
            if (this.types != null && this.types.length > 0) {
                for (i = 0; i < this.types.length; ++i) {
                    element = this.types[i];
                    if (element == null) continue;
                    output.writeString(202, (String)element);
                }
            }
            if (this.dropoutRatios != null && this.dropoutRatios.length > 0) {
                for (i = 0; i < this.dropoutRatios.length; ++i) {
                    output.writeDouble(203, this.dropoutRatios[i]);
                }
            }
            if (this.data != null && this.data.length > 0) {
                for (i = 0; i < this.data.length; ++i) {
                    element = this.data[i];
                    if (element == null) continue;
                    output.writeBytes(300, (byte[])element);
                }
            }
            if (!this.path.equals("")) {
                output.writeString(400, this.path);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            Object element;
            int i;
            int dataSize;
            int dataCount;
            int element2;
            int i2;
            int dataSize2;
            int size = super.computeSerializedSize();
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
            }
            if (!this.graph.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(100, this.graph);
            }
            if (this.inputShape != null && this.inputShape.length > 0) {
                dataSize2 = 0;
                for (i2 = 0; i2 < this.inputShape.length; ++i2) {
                    element2 = this.inputShape[i2];
                    dataSize2 += CodedOutputByteBufferNano.computeInt32SizeNoTag(element2);
                }
                size += dataSize2;
                size += 2 * this.inputShape.length;
            }
            if (!this.solverType.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(102, this.solverType);
            }
            if (Float.floatToIntBits(this.learningRate) != Float.floatToIntBits(0.0f)) {
                size += CodedOutputByteBufferNano.computeFloatSize(103, this.learningRate);
            }
            if (Float.floatToIntBits(this.momentum) != Float.floatToIntBits(0.0f)) {
                size += CodedOutputByteBufferNano.computeFloatSize(104, this.momentum);
            }
            if (this.randomSeed != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(105, this.randomSeed);
            }
            if (this.useGpu) {
                size += CodedOutputByteBufferNano.computeBoolSize(106, this.useGpu);
            }
            if (this.sizes != null && this.sizes.length > 0) {
                dataSize2 = 0;
                for (i2 = 0; i2 < this.sizes.length; ++i2) {
                    element2 = this.sizes[i2];
                    dataSize2 += CodedOutputByteBufferNano.computeInt32SizeNoTag(element2);
                }
                size += dataSize2;
                size += 2 * this.sizes.length;
            }
            if (this.types != null && this.types.length > 0) {
                dataCount = 0;
                dataSize = 0;
                for (i = 0; i < this.types.length; ++i) {
                    element = this.types[i];
                    if (element == null) continue;
                    ++dataCount;
                    dataSize += CodedOutputByteBufferNano.computeStringSizeNoTag((String)element);
                }
                size += dataSize;
                size += 2 * dataCount;
            }
            if (this.dropoutRatios != null && this.dropoutRatios.length > 0) {
                dataSize2 = 8 * this.dropoutRatios.length;
                size += dataSize2;
                size += 2 * this.dropoutRatios.length;
            }
            if (this.data != null && this.data.length > 0) {
                dataCount = 0;
                dataSize = 0;
                for (i = 0; i < this.data.length; ++i) {
                    element = this.data[i];
                    if (element == null) continue;
                    ++dataCount;
                    dataSize += CodedOutputByteBufferNano.computeBytesSizeNoTag((byte[])element);
                }
                size += dataSize;
                size += 2 * dataCount;
            }
            if (!this.path.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(400, this.path);
            }
            return size;
        }

        @Override
        public Cmd mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block22: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block22;
                        return this;
                    }
                    case 8: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: 
                            case 11: {
                                this.type = value;
                            }
                        }
                        continue block22;
                    }
                    case 802: {
                        this.graph = input.readString();
                        continue block22;
                    }
                    case 808: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 808);
                        int i = this.inputShape == null ? 0 : this.inputShape.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.inputShape, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.inputShape = newArray;
                        continue block22;
                    }
                    case 810: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.inputShape == null ? 0 : this.inputShape.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.inputShape, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt32();
                            ++i;
                        }
                        this.inputShape = newArray;
                        input.popLimit(limit);
                        continue block22;
                    }
                    case 818: {
                        this.solverType = input.readString();
                        continue block22;
                    }
                    case 829: {
                        this.learningRate = input.readFloat();
                        continue block22;
                    }
                    case 837: {
                        this.momentum = input.readFloat();
                        continue block22;
                    }
                    case 840: {
                        this.randomSeed = input.readInt64();
                        continue block22;
                    }
                    case 848: {
                        this.useGpu = input.readBool();
                        continue block22;
                    }
                    case 1608: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1608);
                        int i = this.sizes == null ? 0 : this.sizes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.sizes, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.sizes = newArray;
                        continue block22;
                    }
                    case 1610: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.sizes == null ? 0 : this.sizes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.sizes, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt32();
                            ++i;
                        }
                        this.sizes = newArray;
                        input.popLimit(limit);
                        continue block22;
                    }
                    case 1618: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1618);
                        int i = this.types == null ? 0 : this.types.length;
                        String[] newArray = new String[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.types, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readString();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readString();
                        this.types = newArray;
                        continue block22;
                    }
                    case 1625: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 1625);
                        int i = this.dropoutRatios == null ? 0 : this.dropoutRatios.length;
                        double[] newArray = new double[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.dropoutRatios, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readDouble();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readDouble();
                        this.dropoutRatios = newArray;
                        continue block22;
                    }
                    case 1626: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = length / 8;
                        int i = this.dropoutRatios == null ? 0 : this.dropoutRatios.length;
                        double[] newArray = new double[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.dropoutRatios, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readDouble();
                            ++i;
                        }
                        this.dropoutRatios = newArray;
                        input.popLimit(limit);
                        continue block22;
                    }
                    case 2402: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 2402);
                        int i = this.data == null ? 0 : this.data.length;
                        byte[][] newArray = new byte[i + arrayLength][];
                        if (i != 0) {
                            System.arraycopy(this.data, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readBytes();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readBytes();
                        this.data = newArray;
                        continue block22;
                    }
                    case 3202: 
                }
                this.path = input.readString();
            }
        }

        public static Cmd parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new Cmd(), data);
        }

        public static Cmd parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Cmd().mergeFrom(input);
        }
    }
}

