/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.util.ServiceLoader;
import ml.dmlc.xgboost4j.java.INativeLibLoader;

class NativeLibLoaderService {
    private static final String LOADER_NAME = System.getProperty("sys.xgboost.jni.loader");
    private static NativeLibLoaderService service;
    private ServiceLoader<INativeLibLoader> serviceLoader = ServiceLoader.load(INativeLibLoader.class);

    private NativeLibLoaderService() {
    }

    static synchronized NativeLibLoaderService getInstance() {
        if (service == null) {
            service = new NativeLibLoaderService();
        }
        return service;
    }

    INativeLibLoader createLoader() {
        if (LOADER_NAME != null) {
            return this.findLoaderByName(LOADER_NAME);
        }
        return this.findLoaderByPriority();
    }

    private INativeLibLoader findLoaderByName(String name) {
        for (INativeLibLoader nlLoader : this.serviceLoader) {
            if (!name.equals(nlLoader.name())) continue;
            return nlLoader;
        }
        throw new IllegalStateException("Unable to find specified Native Lib Loader (name=" + name + ").");
    }

    private INativeLibLoader findLoaderByPriority() {
        INativeLibLoader selectedLoader = null;
        int maxPriority = Integer.MIN_VALUE;
        for (INativeLibLoader nlLoader : this.serviceLoader) {
            int priority = nlLoader.priority();
            if (priority <= maxPriority) continue;
            selectedLoader = nlLoader;
            maxPriority = priority;
        }
        if (selectedLoader == null) {
            throw new IllegalStateException("Unable to find any Native Lib Loaders.");
        }
        return selectedLoader;
    }
}

