/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy.error;

import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CountingErrorConsumer
extends EasyPredictModelWrapper.ErrorConsumer {
    private AtomicLong dataTransformationErrorsCount = new AtomicLong();
    private Map<String, AtomicLong> unknownCategoricalsPerColumn = new ConcurrentHashMap<String, AtomicLong>();

    public CountingErrorConsumer(GenModel model) {
        for (int i = 0; i < model.getNumCols(); ++i) {
            String[] domainValues = model.getDomainValues(i);
            if (domainValues == null) continue;
            this.unknownCategoricalsPerColumn.put(model.getNames()[i], new AtomicLong());
        }
    }

    @Override
    public void dataTransformError(String columnName, Object value, String message) {
        this.dataTransformationErrorsCount.incrementAndGet();
    }

    @Override
    public void unseenCategorical(String columnName, Object value, String message) {
        this.unknownCategoricalsPerColumn.get(columnName).incrementAndGet();
    }

    public long getTotalUnknownCategoricalLevelsSeen() {
        long total = 0L;
        for (AtomicLong l : this.unknownCategoricalsPerColumn.values()) {
            total += l.get();
        }
        return total;
    }

    public Map<String, AtomicLong> getUnknownCategoricalsPerColumn() {
        return this.unknownCategoricalsPerColumn;
    }

    public long getDataTransformationErrorsCount() {
        return this.dataTransformationErrorsCount.get();
    }
}

