/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.tools.PrintMojo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Objects;

public class SharedTreeGraph {
    public ArrayList<SharedTreeSubgraph> subgraphArray = new ArrayList();

    SharedTreeGraph() {
    }

    SharedTreeSubgraph makeSubgraph(String name) {
        SharedTreeSubgraph sg = new SharedTreeSubgraph(this.subgraphArray.size(), name);
        this.subgraphArray.add(sg);
        return sg;
    }

    public void print() {
        System.out.println("------------------------------------------------------------");
        System.out.println("Graph");
        for (SharedTreeSubgraph sg : this.subgraphArray) {
            sg.print();
        }
    }

    public SharedTreeNode walkNodes(int subgraphId, String path) {
        return this.subgraphArray.get(subgraphId).walkNodes(path);
    }

    public void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions) {
        os.println("/*");
        os.println("Generated by:");
        os.println("    http://https://github.com/h2oai/h2o-3/tree/master/h2o-genmodel/src/main/java/hex/genmodel/tools/PrintMojo.java");
        os.println("*/");
        os.println("");
        os.println("/*");
        os.println("On a mac:");
        os.println("");
        os.println("$ brew install graphviz");
        os.println("$ dot -Tpng file.gv -o file.png");
        os.println("$ open file.png");
        os.println("*/");
        os.println("");
        os.println("digraph G {");
        for (SharedTreeSubgraph sg : this.subgraphArray) {
            sg.printDot(os, maxLevelsToPrintPerEdge, detail, optionalTitle, treeOptions);
        }
        os.println("");
        os.println("}");
        os.println("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedTreeGraph that = (SharedTreeGraph)o;
        return Objects.equals(this.subgraphArray, that.subgraphArray);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphArray);
    }
}

