/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.util.FVec;
import hex.genmodel.GenModel;
import hex.genmodel.algos.xgboost.XGBoostMojoModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class XGBoostJavaMojoModel
extends XGBoostMojoModel {
    Predictor _predictor;

    public XGBoostJavaMojoModel(byte[] boosterBytes, String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
        this._predictor = XGBoostJavaMojoModel.makePredictor(boosterBytes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Predictor makePredictor(byte[] boosterBytes) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(boosterBytes);){
            Predictor predictor = new Predictor(is);
            return predictor;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final double[] score0(double[] doubles, double offset, double[] preds) {
        return XGBoostJavaMojoModel.score0(doubles, offset, preds, this._predictor, this._nums, this._cats, this._catOffsets, this._useAllFactorLevels, this._nclasses, this._priorClassDistrib, this._defaultThreshold, this._sparse);
    }

    private static double[] score0(double[] doubles, double offset, double[] preds, Predictor predictor, int _nums, int _cats, int[] _catOffsets, boolean _useAllFactorLevels, int nclasses, double[] _priorClassDistrib, double _defaultThreshold, boolean _sparse) {
        if (offset != 0.0) {
            throw new UnsupportedOperationException("Unsupported: offset != 0");
        }
        int cats = _catOffsets == null ? 0 : _catOffsets[_cats];
        float[] floats = new float[_nums + cats];
        GenModel.setInput(doubles, floats, _nums, _cats, _catOffsets, null, null, _useAllFactorLevels, _sparse);
        FVec row = FVec.Transformer.fromArray(floats, _sparse);
        double[] out = predictor.predict(row);
        return XGBoostJavaMojoModel.toPreds(doubles, out, preds, nclasses, _priorClassDistrib, _defaultThreshold);
    }

    @Override
    public void close() {
        this._predictor = null;
    }
}

