/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.xgboost;

import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import java.io.Closeable;

public abstract class XGBoostMojoModel
extends MojoModel
implements Closeable {
    public int _nums;
    public int _cats;
    public int[] _catOffsets;
    public boolean _useAllFactorLevels;
    public boolean _sparse;
    public String _featureMap;

    public XGBoostMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public final double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    static double[] toPreds(double[] in, float[] out, double[] preds, int nclasses, double[] priorClassDistrib, double defaultThreshold) {
        if (nclasses > 2) {
            for (int i = 0; i < out.length; ++i) {
                preds[1 + i] = out[i];
            }
            preds[0] = GenModel.getPrediction(preds, priorClassDistrib, in, defaultThreshold);
        } else if (nclasses == 2) {
            preds[1] = 1.0f - out[0];
            preds[2] = out[0];
            preds[0] = GenModel.getPrediction(preds, priorClassDistrib, in, defaultThreshold);
        } else {
            preds[0] = out[0];
        }
        return preds;
    }

    static double[] toPreds(double[] in, double[] out, double[] preds, int nclasses, double[] priorClassDistrib, double defaultThreshold) {
        if (nclasses > 2) {
            for (int i = 0; i < out.length; ++i) {
                preds[1 + i] = out[i];
            }
            preds[0] = GenModel.getPrediction(preds, priorClassDistrib, in, defaultThreshold);
        } else if (nclasses == 2) {
            preds[1] = 1.0 - out[0];
            preds[2] = out[0];
            preds[0] = GenModel.getPrediction(preds, priorClassDistrib, in, defaultThreshold);
        } else {
            preds[0] = out[0];
        }
        return preds;
    }
}

