/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.IClusteringModel;
import hex.genmodel.algos.deepwater.DeepwaterMojoModel;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.word2vec.WordEmbeddingModel;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.error.VoidErrorConsumer;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.exception.PredictNumberFormatException;
import hex.genmodel.easy.exception.PredictUnknownCategoricalLevelException;
import hex.genmodel.easy.exception.PredictUnknownTypeException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.AnomalyDetectionPrediction;
import hex.genmodel.easy.prediction.AutoEncoderModelPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.OrdinalModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import hex.genmodel.easy.prediction.SortedClassProbability;
import hex.genmodel.easy.prediction.Word2VecPrediction;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class EasyPredictModelWrapper
implements Serializable {
    public final GenModel m;
    private final HashMap<String, Integer> modelColumnNameToIndexMap;
    public final HashMap<Integer, HashMap<String, Integer>> domainMap;
    private final ErrorConsumer errorConsumer;
    private final boolean convertUnknownCategoricalLevelsToNa;
    private final boolean convertInvalidNumbersToNa;
    private final boolean useExtendedOutput;
    private final boolean enableLeafAssignment;
    private final boolean enableGLRMReconstruct;

    public EasyPredictModelWrapper(Config config) {
        int i;
        this.m = config.getModel();
        this.errorConsumer = config.getErrorConsumer() == null ? new VoidErrorConsumer() : config.getErrorConsumer();
        this.modelColumnNameToIndexMap = new HashMap();
        String[] modelColumnNames = this.m.getNames();
        for (i = 0; i < modelColumnNames.length; ++i) {
            this.modelColumnNameToIndexMap.put(modelColumnNames[i], i);
        }
        this.convertUnknownCategoricalLevelsToNa = config.getConvertUnknownCategoricalLevelsToNa();
        this.convertInvalidNumbersToNa = config.getConvertInvalidNumbersToNa();
        this.useExtendedOutput = config.getUseExtendedOutput();
        this.enableLeafAssignment = config.getEnableLeafAssignment();
        this.enableGLRMReconstruct = config.getEnableGLRMReconstrut();
        this.domainMap = new HashMap();
        for (i = 0; i < this.m.getNumCols(); ++i) {
            String[] domainValues = this.m.getDomainValues(i);
            if (domainValues == null) continue;
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            for (int j = 0; j < domainValues.length; ++j) {
                m.put(domainValues[j], j);
            }
            this.domainMap.put(i, m);
        }
    }

    public EasyPredictModelWrapper(GenModel model) {
        this(new Config().setModel(model));
    }

    public AbstractPrediction predict(RowData data, ModelCategory mc) throws PredictException {
        switch (mc) {
            case AutoEncoder: {
                return this.predictAutoEncoder(data);
            }
            case Binomial: {
                return this.predictBinomial(data);
            }
            case Multinomial: {
                return this.predictMultinomial(data);
            }
            case Ordinal: {
                return this.predictOrdinal(data);
            }
            case Clustering: {
                return this.predictClustering(data);
            }
            case Regression: {
                return this.predictRegression(data);
            }
            case DimReduction: {
                return this.predictDimReduction(data);
            }
            case WordEmbedding: {
                return this.predictWord2Vec(data);
            }
            case AnomalyDetection: {
                return this.predictAnomalyDetection(data);
            }
            case Unknown: {
                throw new PredictException("Unknown model category");
            }
        }
        throw new PredictException("Unhandled model category (" + (Object)((Object)this.m.getModelCategory()) + ") in switch statement");
    }

    public AbstractPrediction predict(RowData data) throws PredictException {
        return this.predict(data, this.m.getModelCategory());
    }

    public AutoEncoderModelPrediction predictAutoEncoder(RowData data) throws PredictException {
        this.validateModelCategory(ModelCategory.AutoEncoder);
        int size = this.m.getPredsSize(ModelCategory.AutoEncoder);
        double[] output = new double[size];
        double[] rawData = EasyPredictModelWrapper.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        output = this.m.score0(rawData, output);
        AutoEncoderModelPrediction p = new AutoEncoderModelPrediction();
        p.original = this.expandRawData(rawData, output.length);
        p.reconstructed = output;
        p.reconstructedRowData = this.reconstructedToRowData(output);
        return p;
    }

    private double[] expandRawData(double[] data, int size) {
        double[] expanded = new double[size];
        int pos = 0;
        for (int i = 0; i < data.length; ++i) {
            if (this.m._domains[i] == null) {
                expanded[pos] = data[i];
                ++pos;
                continue;
            }
            int idx = Double.isNaN(data[i]) ? this.m._domains[i].length : (int)data[i];
            expanded[pos + idx] = 1.0;
            pos += this.m._domains[i].length + 1;
        }
        return expanded;
    }

    private RowData reconstructedToRowData(double[] reconstructed) {
        RowData rd = new RowData();
        int pos = 0;
        for (int i = 0; i < this.m.nfeatures(); ++i) {
            Object value;
            if (this.m._domains[i] == null) {
                value = reconstructed[pos++];
            } else {
                value = EasyPredictModelWrapper.catValuesAsMap(this.m._domains[i], reconstructed, pos);
                pos += this.m._domains[i].length + 1;
            }
            rd.put(this.m._names[i], value);
        }
        return rd;
    }

    private static Map<String, Double> catValuesAsMap(String[] cats, double[] reconstructed, int offset) {
        HashMap<String, Double> result = new HashMap<String, Double>(cats.length + 1);
        for (int i = 0; i < cats.length; ++i) {
            result.put(cats[i], reconstructed[i + offset]);
        }
        result.put(null, reconstructed[offset + cats.length]);
        return result;
    }

    public DimReductionModelPrediction predictDimReduction(RowData data) throws PredictException {
        double[] preds = this.preamble(ModelCategory.DimReduction, data);
        DimReductionModelPrediction p = new DimReductionModelPrediction();
        p.dimensions = preds;
        if (this.m instanceof GlrmMojoModel && ((GlrmMojoModel)this.m)._archetypes_raw != null && this.enableGLRMReconstruct) {
            GlrmMojoModel cfr_ignored_0 = (GlrmMojoModel)this.m;
            p.reconstructed = GlrmMojoModel.impute_data(preds, new double[this.m.nfeatures()], ((GlrmMojoModel)this.m)._nnums, ((GlrmMojoModel)this.m)._ncats, ((GlrmMojoModel)this.m)._permutation, ((GlrmMojoModel)this.m)._reverse_transform, ((GlrmMojoModel)this.m)._normMul, ((GlrmMojoModel)this.m)._normSub, ((GlrmMojoModel)this.m)._losses, ((GlrmMojoModel)this.m)._transposed, ((GlrmMojoModel)this.m)._archetypes_raw, ((GlrmMojoModel)this.m)._catOffsets, ((GlrmMojoModel)this.m)._numLevels);
        }
        return p;
    }

    public Word2VecPrediction predictWord2Vec(RowData data) throws PredictException {
        this.validateModelCategory(ModelCategory.WordEmbedding);
        if (!(this.m instanceof WordEmbeddingModel)) {
            throw new PredictException("Model is not of the expected type, class = " + this.m.getClass().getSimpleName());
        }
        WordEmbeddingModel weModel = (WordEmbeddingModel)((Object)this.m);
        int vecSize = weModel.getVecSize();
        HashMap<String, float[]> embeddings = new HashMap<String, float[]>(data.size());
        for (String wordKey : data.keySet()) {
            Object value = data.get(wordKey);
            if (!(value instanceof String)) continue;
            String word = (String)value;
            embeddings.put(wordKey, weModel.transform0(word, new float[vecSize]));
        }
        Word2VecPrediction p = new Word2VecPrediction();
        p.wordEmbeddings = embeddings;
        return p;
    }

    public AnomalyDetectionPrediction predictAnomalyDetection(RowData data) throws PredictException {
        double[] preds = this.preamble(ModelCategory.AnomalyDetection, data, 0.0);
        AnomalyDetectionPrediction p = new AnomalyDetectionPrediction();
        p.normalizedScore = preds[0];
        p.score = preds[1];
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p.leafNodeAssignments = assignments._paths;
            p.leafNodeAssignmentIds = assignments._nodeIds;
        }
        return p;
    }

    public BinomialModelPrediction predictBinomial(RowData data) throws PredictException {
        return this.predictBinomial(data, 0.0);
    }

    public BinomialModelPrediction predictBinomial(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Binomial, data, offset);
        BinomialModelPrediction p = new BinomialModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p.leafNodeAssignments = assignments._paths;
            p.leafNodeAssignmentIds = assignments._nodeIds;
        }
        double d = preds[0];
        p.labelIndex = (int)d;
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        if (domainValues == null && this.m.getNumResponseClasses() == 2) {
            domainValues = new String[]{"0", "1"};
        }
        p.label = domainValues[p.labelIndex];
        p.classProbabilities = new double[this.m.getNumResponseClasses()];
        System.arraycopy(preds, 1, p.classProbabilities, 0, p.classProbabilities.length);
        if (this.m.calibrateClassProbabilities(preds)) {
            p.calibratedClassProbabilities = new double[this.m.getNumResponseClasses()];
            System.arraycopy(preds, 1, p.calibratedClassProbabilities, 0, p.calibratedClassProbabilities.length);
        }
        return p;
    }

    public String[] leafNodeAssignment(RowData data) throws PredictException {
        double[] rawData = EasyPredictModelWrapper.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return ((SharedTreeMojoModel)this.m).getDecisionPath(rawData);
    }

    public SharedTreeMojoModel.LeafNodeAssignments leafNodeAssignmentExtended(RowData data) throws PredictException {
        double[] rawData = EasyPredictModelWrapper.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        return ((SharedTreeMojoModel)this.m).getLeafNodeAssignments(rawData);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data) throws PredictException {
        return this.predictMultinomial(data, 0.0);
    }

    public MultinomialModelPrediction predictMultinomial(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Multinomial, data, offset);
        MultinomialModelPrediction p = new MultinomialModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p.leafNodeAssignments = assignments._paths;
            p.leafNodeAssignmentIds = assignments._nodeIds;
        }
        p.classProbabilities = new double[this.m.getNumResponseClasses()];
        p.labelIndex = (int)preds[0];
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        p.label = domainValues[p.labelIndex];
        System.arraycopy(preds, 1, p.classProbabilities, 0, p.classProbabilities.length);
        return p;
    }

    public OrdinalModelPrediction predictOrdinal(RowData data) throws PredictException {
        return this.predictOrdinal(data, 0.0);
    }

    public OrdinalModelPrediction predictOrdinal(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Ordinal, data, offset);
        OrdinalModelPrediction p = new OrdinalModelPrediction();
        p.classProbabilities = new double[this.m.getNumResponseClasses()];
        p.labelIndex = (int)preds[0];
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        p.label = domainValues[p.labelIndex];
        System.arraycopy(preds, 1, p.classProbabilities, 0, p.classProbabilities.length);
        return p;
    }

    private SortedClassProbability[] sortByDescendingClassProbability(String[] domainValues, double[] classProbabilities) {
        assert (classProbabilities.length == domainValues.length);
        SortedClassProbability[] arr = new SortedClassProbability[domainValues.length];
        for (int i = 0; i < domainValues.length; ++i) {
            arr[i] = new SortedClassProbability();
            arr[i].name = domainValues[i];
            arr[i].probability = classProbabilities[i];
        }
        Arrays.sort(arr, Collections.reverseOrder());
        return arr;
    }

    public SortedClassProbability[] sortByDescendingClassProbability(BinomialModelPrediction p) {
        String[] domainValues = this.m.getDomainValues(this.m.getResponseIdx());
        double[] classProbabilities = p.classProbabilities;
        return this.sortByDescendingClassProbability(domainValues, classProbabilities);
    }

    public ClusteringModelPrediction predictClustering(RowData data) throws PredictException {
        ClusteringModelPrediction p = new ClusteringModelPrediction();
        if (this.useExtendedOutput && this.m instanceof IClusteringModel) {
            IClusteringModel cm = (IClusteringModel)((Object)this.m);
            double[] rawData = EasyPredictModelWrapper.nanArray(this.m.nfeatures());
            rawData = this.fillRawData(data, rawData);
            int k = cm.getNumClusters();
            p.distances = new double[k];
            p.cluster = cm.distances(rawData, p.distances);
        } else {
            double[] preds = this.preamble(ModelCategory.Clustering, data);
            p.cluster = (int)preds[0];
        }
        return p;
    }

    public RegressionModelPrediction predictRegression(RowData data) throws PredictException {
        return this.predictRegression(data, 0.0);
    }

    public RegressionModelPrediction predictRegression(RowData data, double offset) throws PredictException {
        double[] preds = this.preamble(ModelCategory.Regression, data, offset);
        RegressionModelPrediction p = new RegressionModelPrediction();
        if (this.enableLeafAssignment) {
            SharedTreeMojoModel.LeafNodeAssignments assignments = this.leafNodeAssignmentExtended(data);
            p.leafNodeAssignments = assignments._paths;
            p.leafNodeAssignmentIds = assignments._nodeIds;
        }
        p.value = preds[0];
        return p;
    }

    public ModelCategory getModelCategory() {
        return this.m.getModelCategory();
    }

    public String[] getResponseDomainValues() {
        return this.m.getDomainValues(this.m.getResponseIdx());
    }

    public String getHeader() {
        return this.m.getHeader();
    }

    private void validateModelCategory(ModelCategory c) throws PredictException {
        if (!this.m.getModelCategories().contains((Object)c)) {
            throw new PredictException((Object)((Object)c) + " prediction type is not supported for this model.");
        }
    }

    protected double[] preamble(ModelCategory c, RowData data) throws PredictException {
        return this.preamble(c, data, 0.0);
    }

    protected double[] preamble(ModelCategory c, RowData data, double offset) throws PredictException {
        this.validateModelCategory(c);
        return this.predict(data, offset, new double[this.m.getPredsSize(c)]);
    }

    private static double[] nanArray(int len) {
        double[] arr = new double[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = Double.NaN;
        }
        return arr;
    }

    /*
     * Unable to fully structure code
     */
    protected double[] fillRawData(RowData data, double[] rawData) throws PredictException {
        isImage = this.m instanceof DeepwaterMojoModel != false && ((DeepwaterMojoModel)this.m)._problem_type.equals("image") != false;
        isText = this.m instanceof DeepwaterMojoModel != false && ((DeepwaterMojoModel)this.m)._problem_type.equals("text") != false;
        for (String dataColumnName : data.keySet()) {
            block28: {
                block27: {
                    index = this.modelColumnNameToIndexMap.get(dataColumnName);
                    if (index == null || index >= rawData.length) continue;
                    img = null;
                    domainValues = this.m.getDomainValues(index);
                    if (domainValues == null) {
                        value = NaN;
                        o = data.get(dataColumnName);
                        if (o instanceof String) {
                            s = ((String)o).trim();
                            if (isImage) {
                                isURL = s.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                                try {
                                    img = isURL != false ? ImageIO.read(new URL(s)) : ImageIO.read(new File(s));
                                }
                                catch (IOException e) {
                                    throw new PredictException("Couldn't read image from " + s);
                                }
                            } else {
                                if (isText) {
                                    throw new PredictException("MOJO scoring for text classification is not yet implemented.");
                                }
                                try {
                                    value = Double.parseDouble(s);
                                }
                                catch (NumberFormatException nfe) {
                                    if (this.convertInvalidNumbersToNa) ** GOTO lbl39
                                    throw new PredictNumberFormatException("Unable to parse value: " + s + ", from column: " + dataColumnName + ", as Double; " + nfe.getMessage());
                                }
                            }
                        } else if (o instanceof Double) {
                            value = (Double)o;
                        } else if (o instanceof byte[] && isImage) {
                            is = new ByteArrayInputStream((byte[])o);
                            try {
                                img = ImageIO.read(is);
                            }
                            catch (IOException e) {
                                throw new PredictException("Couldn't interpret raw bytes as an image.");
                            }
                        } else {
                            throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for numeric column " + dataColumnName);
                        }
lbl39:
                        // 5 sources

                        if (isImage && img != null) {
                            dwm = (DeepwaterMojoModel)this.m;
                            W = dwm._width;
                            H = dwm._height;
                            C = dwm._channels;
                            _destData = new float[W * H * C];
                            try {
                                GenModel.img2pixels(img, W, H, C, _destData, 0, dwm._meanImageData);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                throw new PredictException("Couldn't vectorize image.");
                            }
                            rawData = new double[_destData.length];
                            for (i = 0; i < rawData.length; ++i) {
                                rawData[i] = _destData[i];
                            }
                            return rawData;
                        }
                        if (Double.isNaN(value)) {
                            this.errorConsumer.dataTransformError(dataColumnName, o, "Given non-categorical value is unparseable, treating as NaN.");
                        }
                        rawData[index.intValue()] = value;
                        continue;
                    }
                    o = data.get(dataColumnName);
                    if (!(o instanceof String)) break block27;
                    levelName = (String)o;
                    columnDomainMap = this.domainMap.get(index);
                    levelIndex = columnDomainMap.get(levelName);
                    if (levelIndex == null) {
                        levelIndex = columnDomainMap.get(dataColumnName + "." + levelName);
                    }
                    if (levelIndex != null) ** GOTO lbl74
                    if (this.convertUnknownCategoricalLevelsToNa) {
                        value = NaN;
                        this.errorConsumer.unseenCategorical(dataColumnName, o, "Previously unseen categorical level detected, marking as NaN.");
                    } else {
                        this.errorConsumer.dataTransformError(dataColumnName, o, "Unknown categorical level detected.");
                        throw new PredictUnknownCategoricalLevelException("Unknown categorical level (" + dataColumnName + "," + levelName + ")", dataColumnName, levelName);
lbl74:
                        // 1 sources

                        value = levelIndex.intValue();
                    }
                    break block28;
                }
                if (o instanceof Double && Double.isNaN((Double)o)) {
                    this.errorConsumer.dataTransformError(dataColumnName, o, "Missing factor value detected, setting to NaN");
                    value = (Double)o;
                } else {
                    this.errorConsumer.dataTransformError(dataColumnName, o, "Unknown categorical variable type.");
                    throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for categorical column " + dataColumnName);
                }
            }
            rawData[index.intValue()] = value;
        }
        return rawData;
    }

    protected double[] predict(RowData data, double offset, double[] preds) throws PredictException {
        double[] rawData = EasyPredictModelWrapper.nanArray(this.m.nfeatures());
        rawData = this.fillRawData(data, rawData);
        preds = offset == 0.0 ? this.m.score0(rawData, preds) : this.m.score0(rawData, offset, preds);
        return preds;
    }

    public static class Config {
        private GenModel model;
        private boolean convertUnknownCategoricalLevelsToNa = false;
        private boolean convertInvalidNumbersToNa = false;
        private boolean useExtendedOutput = false;
        private ErrorConsumer errorConsumer;
        private boolean enableLeafAssignment = false;
        private boolean enableGLRMReconstrut = false;

        public Config setModel(GenModel value) {
            this.model = value;
            return this;
        }

        public GenModel getModel() {
            return this.model;
        }

        public Config setConvertUnknownCategoricalLevelsToNa(boolean value) {
            this.convertUnknownCategoricalLevelsToNa = value;
            return this;
        }

        public Config setEnableLeafAssignment(boolean val) throws IOException {
            if (val && this.model == null) {
                throw new IOException("enableLeafAssignment cannot be set with null model.  Call setModel() first.");
            }
            if (val && !(this.model instanceof SharedTreeMojoModel)) {
                throw new IOException("enableLeafAssignment can be set to true only with SharedTreeMojoModel, i.e. with GBM or DRF.");
            }
            this.enableLeafAssignment = val;
            return this;
        }

        public Config setEnableGLRMReconstrut(boolean value) throws IOException {
            if (value && this.model == null) {
                throw new IOException("Cannot set enableGLRMReconstruct for a null model.  Call config.setModel() first.");
            }
            if (value && !(this.model instanceof GlrmMojoModel)) {
                throw new IOException("enableGLRMReconstruct shall only be used with GlrmMojoModels.");
            }
            this.enableGLRMReconstrut = value;
            return this;
        }

        public boolean getEnableGLRMReconstrut() {
            return this.enableGLRMReconstrut;
        }

        public boolean getConvertUnknownCategoricalLevelsToNa() {
            return this.convertUnknownCategoricalLevelsToNa;
        }

        public Config setConvertInvalidNumbersToNa(boolean value) {
            this.convertInvalidNumbersToNa = value;
            return this;
        }

        public boolean getConvertInvalidNumbersToNa() {
            return this.convertInvalidNumbersToNa;
        }

        public Config setUseExtendedOutput(boolean value) {
            this.useExtendedOutput = value;
            return this;
        }

        public boolean getUseExtendedOutput() {
            return this.useExtendedOutput;
        }

        public boolean getEnableLeafAssignment() {
            return this.enableLeafAssignment;
        }

        public ErrorConsumer getErrorConsumer() {
            return this.errorConsumer;
        }

        public Config setErrorConsumer(ErrorConsumer errorConsumer) {
            this.errorConsumer = errorConsumer;
            return this;
        }
    }

    public static abstract class ErrorConsumer
    implements Serializable {
        public abstract void dataTransformError(String var1, Object var2, String var3);

        public abstract void unseenCategorical(String var1, Object var2, String var3);
    }
}

