/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Map;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KryoBooster
extends Booster
implements KryoSerializable {
    private static final Log logger = LogFactory.getLog(KryoBooster.class);

    KryoBooster(Map<String, Object> params, DMatrix[] cacheMats) throws XGBoostError {
        super(params, cacheMats, true);
    }

    KryoBooster() {
        super(true);
    }

    public void write(Kryo kryo, Output output) {
        byte[] serObj;
        try {
            serObj = this.toByteArray();
        }
        catch (XGBoostError ex) {
            throw new RuntimeException("Booster serialization failed", ex);
        }
        int serObjSize = serObj.length;
        logger.debug("==== serialized obj size " + serObjSize);
        output.writeInt(serObjSize);
        output.write(serObj);
    }

    public void read(Kryo kryo, Input input) {
        int serObjSize = input.readInt();
        logger.debug("==== the size of the object: " + serObjSize);
        byte[] bytes = new byte[serObjSize];
        input.readBytes(bytes);
        try {
            this.initFromBytes(bytes);
        }
        catch (XGBoostError ex) {
            throw new RuntimeException("Booster deserialization failed", ex);
        }
    }
}

