/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonObject;
import hex.ModelCategory;
import hex.genmodel.MojoModel;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.metrics.MojoModelMetrics;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegression;
import java.io.Serializable;

public class ModelAttributes
implements Serializable {
    private final Table _modelSummary;
    private final Table _scoring_history;
    private final MojoModelMetrics _trainingMetrics;
    private final MojoModelMetrics _validation_metrics;
    private final MojoModelMetrics _cross_validation_metrics;
    private final Table _cross_validation_metrics_summary;

    public ModelAttributes(MojoModel model, JsonObject modelJson) {
        this._modelSummary = ModelJsonReader.readTable(modelJson, "output.model_summary");
        this._scoring_history = ModelJsonReader.readTable(modelJson, "output.scoring_history");
        if (ModelJsonReader.elementExists(modelJson, "output.training_metrics")) {
            this._trainingMetrics = ModelAttributes.determineModelMetricsType(model._category);
            ModelJsonReader.fillObject(this._trainingMetrics, modelJson, "output.training_metrics");
        } else {
            this._trainingMetrics = null;
        }
        if (ModelJsonReader.elementExists(modelJson, "output.validation_metrics")) {
            this._validation_metrics = ModelAttributes.determineModelMetricsType(model._category);
            ModelJsonReader.fillObject(this._validation_metrics, modelJson, "output.validation_metrics");
        } else {
            this._validation_metrics = null;
        }
        if (ModelJsonReader.elementExists(modelJson, "output.cross_validation_metrics")) {
            this._cross_validation_metrics_summary = ModelJsonReader.readTable(modelJson, "output.cross_validation_metrics_summary");
            this._cross_validation_metrics = ModelAttributes.determineModelMetricsType(model._category);
            ModelJsonReader.fillObject(this._cross_validation_metrics, modelJson, "output.cross_validation_metrics");
        } else {
            this._cross_validation_metrics = null;
            this._cross_validation_metrics_summary = null;
        }
    }

    private static MojoModelMetrics determineModelMetricsType(ModelCategory modelCategory) {
        switch (modelCategory) {
            case Unknown: {
                return new MojoModelMetrics();
            }
            case Binomial: {
                return new MojoModelMetricsBinomial();
            }
            case Multinomial: {
                return new MojoModelMetricsMultinomial();
            }
            case Regression: {
                return new MojoModelMetricsRegression();
            }
        }
        return new MojoModelMetrics();
    }

    public Table getModelSummary() {
        return this._modelSummary;
    }

    public Table getScoringHistory() {
        return this._scoring_history;
    }

    public MojoModelMetrics getTrainingMetrics() {
        return this._trainingMetrics;
    }

    public MojoModelMetrics getValidationMetrics() {
        return this._validation_metrics;
    }

    public MojoModelMetrics getCrossValidationMetrics() {
        return this._cross_validation_metrics;
    }

    public Table getCrossValidationMetricsSummary() {
        return this._cross_validation_metrics_summary;
    }
}

