/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.metrics.SerializedName;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.regex.Pattern;

public class ModelJsonReader {
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject parseModelJson(MojoReaderBackend mojoReaderBackend) {
        try (BufferedReader fileReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);){
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = gson.fromJson((Reader)fileReader, JsonObject.class);
            return jsonObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Table readTable(JsonObject modelJson, String tablePath) {
        Objects.requireNonNull(modelJson);
        JsonElement potentialTableJson = ModelJsonReader.findInJson(modelJson, tablePath);
        if (potentialTableJson.isJsonNull()) {
            System.out.println(String.format("Failed to extract element '%s' MojoModel dump.", tablePath));
            return null;
        }
        JsonObject tableJson = potentialTableJson.getAsJsonObject();
        int rowCount = tableJson.get("rowcount").getAsInt();
        JsonArray columns = ModelJsonReader.findInJson(tableJson, "columns").getAsJsonArray();
        int columnCount = columns.size();
        String[] columnHeaders = new String[columnCount];
        Table.ColumnType[] columnTypes = new Table.ColumnType[columnCount];
        String[] columnFormats = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonObject column = columns.get(i).getAsJsonObject();
            columnHeaders[i] = column.get("description").getAsString();
            columnTypes[i] = Table.ColumnType.extractType(column.get("type").getAsString());
            columnFormats[i] = column.get("format").getAsString();
        }
        JsonArray dataColumns = ModelJsonReader.findInJson(tableJson, "data").getAsJsonArray();
        Object[][] data = new Object[columnCount][rowCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonArray column = dataColumns.get(i).getAsJsonArray();
            block9: for (int j = 0; j < rowCount; ++j) {
                JsonElement cellValue = column.get(j);
                if (cellValue == null || !cellValue.isJsonPrimitive()) {
                    data[i][j] = null;
                    continue;
                }
                JsonPrimitive primitiveValue = cellValue.getAsJsonPrimitive();
                switch (columnTypes[i]) {
                    case LONG: {
                        if (primitiveValue.isNumber()) {
                            data[i][j] = primitiveValue.getAsLong();
                            continue block9;
                        }
                        data[i][j] = null;
                        continue block9;
                    }
                    case DOUBLE: {
                        if (primitiveValue.isNumber()) {
                            data[i][j] = primitiveValue.getAsDouble();
                            continue block9;
                        }
                        data[i][j] = null;
                        continue block9;
                    }
                    case FLOAT: {
                        data[i][j] = primitiveValue.isNumber() ? Float.valueOf(primitiveValue.getAsFloat()) : null;
                    }
                    case INT: {
                        data[i][j] = primitiveValue.isNumber() ? Integer.valueOf(primitiveValue.getAsInt()) : null;
                    }
                    case STRING: {
                        data[i][j] = primitiveValue.getAsString();
                    }
                }
            }
        }
        return new Table(tableJson.get("name").getAsString(), tableJson.get("description").getAsString(), new String[rowCount], columnHeaders, columnTypes, null, columnFormats, data);
    }

    public static void fillObject(Object object, JsonElement from, String elementPath) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(elementPath);
        JsonElement jsonSourceObject = ModelJsonReader.findInJson(from, elementPath);
        if (jsonSourceObject instanceof JsonNull) {
            System.out.println(String.format("Element '%s' not found in JSON. Skipping. Object '%s' is not populated by values.", elementPath, object.getClass().getName()));
            return;
        }
        JsonObject jsonSourceObj = jsonSourceObject.getAsJsonObject();
        Class<?> aClass = object.getClass();
        Field[] declaredFields = aClass.getFields();
        for (int i = 0; i < declaredFields.length; ++i) {
            String name;
            Field field = declaredFields[i];
            if (Modifier.isTransient(field.getModifiers())) continue;
            Class<Object> type = field.getType();
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            String fieldName = serializedName == null ? ((name = field.getName()).charAt(0) == '_' ? name.substring(1) : name) : serializedName.value();
            try {
                JsonElement jsonElement;
                field.setAccessible(true);
                assert (field.isAccessible());
                Object value = null;
                if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsDouble();
                    }
                } else if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsInt();
                    }
                } else if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsLong();
                    }
                } else if (type.isAssignableFrom(String.class)) {
                    jsonElement = jsonSourceObj.get(fieldName);
                    if (jsonElement != null && !jsonElement.isJsonNull()) {
                        value = jsonElement.getAsString();
                    }
                } else if (type.isAssignableFrom(Table.class) && (jsonElement = jsonSourceObj.get(fieldName)) != null && !jsonElement.isJsonNull()) {
                    value = ModelJsonReader.readTable(jsonElement.getAsJsonObject(), serializedName != null ? serializedName.insideElementPath() : "");
                }
                if (value == null) continue;
                field.set(object, value);
                continue;
            }
            catch (IllegalAccessException e) {
                System.out.println(String.format("Field '%s' could not be accessed. Ignoring.", fieldName));
                continue;
            }
            catch (ClassCastException | UnsupportedOperationException e) {
                System.out.println(String.format("Field '%s' could not be casted to '%s'. Ignoring.", fieldName, type.toString()));
            }
        }
    }

    private static JsonElement findInJson(JsonElement jsonElement, String jsonPath) {
        String[] route = JSON_PATH_PATTERN.split(jsonPath);
        JsonElement result = jsonElement;
        for (String key : route) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) {
                result = JsonNull.INSTANCE;
                break;
            }
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            int value = Integer.valueOf(key) - 1;
            result = ((JsonArray)result).get(value);
        }
        return result;
    }

    public static boolean elementExists(JsonElement jsonElement, String jsonPath) {
        boolean isEmpty = ModelJsonReader.findInJson(jsonElement, jsonPath) instanceof JsonNull;
        return !isEmpty;
    }
}

