/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class PrintMojo {
    private GenModel genModel;
    private static boolean printRaw = false;
    private static int treeToPrint = -1;
    private static int maxLevelsToPrintPerEdge = 10;
    private static boolean detail = false;
    private static String outputFileName = null;
    private static String optionalTitle = null;
    private static PrintTreeOptions pTreeOptions;
    private static boolean internal;

    public static void main(String[] args) {
        PrintMojo main = new PrintMojo();
        main.parseArgs(args);
        try {
            main.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private void loadMojo(String modelName) throws IOException {
        this.genModel = MojoModel.load(modelName);
    }

    private static void usage() {
        System.out.println("Emit a human-consumable graph of a model for use with dot (graphviz).");
        System.out.println("The currently supported model types are DRF, GBM and XGBoost.");
        System.out.println("");
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.PrintMojo [--tree n] [--levels n] [--title sss] [-o outputFileName]");
        System.out.println("");
        System.out.println("    --tree          Tree number to print.");
        System.out.println("                    [default all]");
        System.out.println("");
        System.out.println("    --levels        Number of levels per edge to print.");
        System.out.println("                    [default " + maxLevelsToPrintPerEdge + "]");
        System.out.println("");
        System.out.println("    --title         (Optional) Force title of tree graph.");
        System.out.println("");
        System.out.println("    --detail        Specify to print additional detailed information like node numbers.");
        System.out.println("");
        System.out.println("    --input | -i    Input mojo file.");
        System.out.println("");
        System.out.println("    --output | -o   Output dot filename.");
        System.out.println("                    [default stdout]");
        System.out.println("    --decimalplaces | -d    Set decimal places of all numerical values.");
        System.out.println("");
        System.out.println("    --fontsize | -f    Set font sizes of strings.");
        System.out.println("");
        System.out.println("    --internal    Internal H2O representation of the decision tree (splits etc.) is used for generating the GRAPHVIZ format.");
        System.out.println("");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("");
        System.out.println("    (brew install graphviz)");
        System.out.println("    java -cp h2o.jar hex.genmodel.tools.PrintMojo --tree 0 -i model_mojo.zip -o model.gv -f 20 -d 3");
        System.out.println("    dot -Tpng model.gv -o model.png");
        System.out.println("    open model.png");
        System.out.println();
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        int nPlaces = -1;
        int fontSize = 14;
        boolean setDecimalPlaces = false;
        try {
            block34: for (int i = 0; i < args.length; ++i) {
                String s;
                switch (s = args[i]) {
                    case "--tree": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        try {
                            treeToPrint = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            System.out.println("ERROR: invalid --tree argument (" + s + ")");
                            System.exit(1);
                        }
                        continue block34;
                    }
                    case "--levels": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        try {
                            maxLevelsToPrintPerEdge = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            System.out.println("ERROR: invalid --levels argument (" + s + ")");
                            System.exit(1);
                        }
                        continue block34;
                    }
                    case "--title": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        optionalTitle = args[i];
                        continue block34;
                    }
                    case "--detail": {
                        detail = true;
                        continue block34;
                    }
                    case "--input": 
                    case "-i": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        this.loadMojo(s);
                        continue block34;
                    }
                    case "--fontsize": 
                    case "-f": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        fontSize = Integer.parseInt(s);
                        continue block34;
                    }
                    case "--decimalplaces": 
                    case "-d": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        setDecimalPlaces = true;
                        s = args[i];
                        nPlaces = Integer.parseInt(s);
                        continue block34;
                    }
                    case "--raw": {
                        printRaw = true;
                        continue block34;
                    }
                    case "--internal": {
                        internal = true;
                        continue block34;
                    }
                    case "-o": 
                    case "--output": {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        outputFileName = args[i];
                        continue block34;
                    }
                    default: {
                        System.out.println("ERROR: Unknown command line argument: " + s);
                        PrintMojo.usage();
                    }
                }
            }
            pTreeOptions = new PrintTreeOptions(setDecimalPlaces, nPlaces, fontSize, internal);
        }
        catch (Exception e) {
            e.printStackTrace();
            PrintMojo.usage();
        }
    }

    private void validateArgs() {
        if (this.genModel == null) {
            System.out.println("ERROR: Must specify -i");
            PrintMojo.usage();
        }
    }

    private void run() throws Exception {
        this.validateArgs();
        PrintStream os = outputFileName != null ? new PrintStream(new FileOutputStream(new File(outputFileName))) : System.out;
        if (this.genModel instanceof SharedTreeGraphConverter) {
            SharedTreeGraphConverter treeBackedModel = (SharedTreeGraphConverter)((Object)this.genModel);
            SharedTreeGraph g = treeBackedModel.convert(treeToPrint, null);
            if (printRaw) {
                g.print();
            }
            g.printDot(os, maxLevelsToPrintPerEdge, detail, optionalTitle, pTreeOptions);
        } else {
            System.out.println("ERROR: Unknown MOJO type");
            System.exit(1);
        }
    }

    public class PrintTreeOptions {
        public boolean _setDecimalPlace = false;
        public int _nPlaces = -1;
        public int _fontSize = 14;
        public boolean _internal;

        public PrintTreeOptions(boolean setdecimalplaces, int nplaces, int fontsize, boolean internal) {
            this._setDecimalPlace = setdecimalplaces;
            this._nPlaces = this._setDecimalPlace ? nplaces : this._nPlaces;
            this._fontSize = fontsize;
            this._internal = internal;
        }

        public float roundNPlace(float value) {
            if (this._nPlaces < 0) {
                return value;
            }
            double sc = Math.pow(10.0, this._nPlaces);
            return (float)((double)Math.round((double)value * sc) / sc);
        }
    }
}

