/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.ModelMojoFactory;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.utils.ParseUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class ModelMojoReader<M extends MojoModel> {
    protected M _model;
    private MojoReaderBackend _reader;
    private Map<String, Object> _lkv;

    public static MojoModel readFrom(MojoReaderBackend reader) throws IOException {
        Map<String, Object> info = ModelMojoReader.parseModelInfo(reader);
        String algo = (String)info.get("algorithm");
        ModelMojoReader mmr = ModelMojoFactory.getMojoReader(algo);
        mmr._lkv = info;
        mmr._reader = reader;
        mmr.readAll();
        return mmr._model;
    }

    protected abstract void readModelData() throws IOException;

    protected abstract M makeModel(String[] var1, String[][] var2);

    protected <T> T readkv(String key) {
        return (T)this._lkv.get(key);
    }

    protected byte[] readblob(String name) throws IOException {
        return this._reader.getBinaryFile(name);
    }

    protected Iterable<String> readtext(String name) throws IOException {
        String line;
        BufferedReader br = this._reader.getTextFile(name);
        ArrayList<String> res = new ArrayList<String>(50);
        while ((line = br.readLine()) != null) {
            res.add(line.trim());
        }
        return res;
    }

    private void readAll() throws IOException {
        String[] columns = (String[])this._lkv.get("[columns]");
        String[][] domains = this.parseModelDomains(columns.length);
        this._model = this.makeModel(columns, domains);
        ((MojoModel)this._model)._uuid = (String)this.readkv("uuid");
        ((MojoModel)this._model)._category = ModelCategory.valueOf((String)this.readkv("category"));
        ((MojoModel)this._model)._supervised = (Boolean)this.readkv("supervised");
        ((MojoModel)this._model)._nfeatures = (Integer)this.readkv("n_features");
        ((MojoModel)this._model)._nclasses = (Integer)this.readkv("n_classes");
        ((MojoModel)this._model)._balanceClasses = (Boolean)this.readkv("balance_classes");
        ((MojoModel)this._model)._defaultThreshold = (Double)this.readkv("default_threshold");
        ((MojoModel)this._model)._priorClassDistrib = (double[])this.readkv("prior_class_distrib");
        ((MojoModel)this._model)._modelClassDistrib = (double[])this.readkv("model_class_distrib");
        ((MojoModel)this._model)._offsetColumn = (String)this.readkv("offset_column");
        this.readModelData();
    }

    private static Map<String, Object> parseModelInfo(MojoReaderBackend reader) throws IOException {
        String line;
        BufferedReader br = reader.getTextFile("model.ini");
        HashMap<String, Object> info = new HashMap<String, Object>();
        int section = 0;
        int ic = 0;
        String[] columns = new String[]{};
        HashMap<Integer, String> domains = new HashMap<Integer, String>();
        while ((line = br.readLine()) != null) {
            String[] res;
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            if (line.equals("[info]")) {
                section = 1;
                continue;
            }
            if (line.equals("[columns]")) {
                section = 2;
                Integer n_columns = (Integer)info.get("n_columns");
                if (n_columns == null) {
                    throw new IOException("`n_columns` variable is missing in the model info.");
                }
                columns = new String[n_columns.intValue()];
                info.put("[columns]", columns);
                continue;
            }
            if (line.equals("[domains]")) {
                section = 3;
                info.put("[domains]", domains);
                continue;
            }
            if (section == 1) {
                res = line.split("\\s*=\\s*", 2);
                info.put(res[0], res[0].equals("uuid") ? res[1] : ParseUtils.tryParse(res[1]));
                continue;
            }
            if (section == 2) {
                if (ic >= columns.length) {
                    throw new IOException("`n_columns` variable is too small.");
                }
                columns[ic++] = line;
                continue;
            }
            if (section != 3) continue;
            res = line.split(":\\s*", 2);
            int col_index = Integer.parseInt(res[0]);
            domains.put(col_index, res[1]);
        }
        return info;
    }

    private String[][] parseModelDomains(int n_columns) throws IOException {
        String[][] domains = new String[n_columns][];
        Map domass = (Map)this._lkv.get("[domains]");
        for (Map.Entry e : domass.entrySet()) {
            String line;
            int col_index = (Integer)e.getKey();
            if (col_index >= n_columns) continue;
            String[] info = ((String)e.getValue()).split(" ", 2);
            int n_elements = Integer.parseInt(info[0]);
            String domfile = info[1];
            String[] domain = new String[n_elements];
            BufferedReader br = this._reader.getTextFile("domains/" + domfile);
            int id = 0;
            while ((line = br.readLine()) != null) {
                domain[id++] = line;
            }
            if (id != n_elements) {
                throw new IOException("Not enough elements in the domain file");
            }
            domains[col_index] = domain;
        }
        return domains;
    }
}

