/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.glm;

import hex.genmodel.algos.glm.GlmMojoModelBase;

public class GlmMultinomialMojoModel
extends GlmMojoModelBase {
    private int P;
    private int noff;

    GlmMultinomialMojoModel(String[] columns, String[][] domains) {
        super(columns, domains);
    }

    @Override
    void init() {
        this.P = this._beta.length / this._nclasses;
        if (this.P * this._nclasses != this._beta.length) {
            throw new IllegalStateException("Incorrect coding of Beta.");
        }
        this.noff = this._catOffsets[this._cats];
    }

    @Override
    double[] glmScore0(double[] data, double[] preds) {
        preds[0] = 0.0;
        for (int c = 0; c < this._nclasses; ++c) {
            int i;
            preds[c + 1] = 0.0;
            if (this._cats > 0) {
                int ival;
                if (!this._useAllFactorLevels) {
                    for (i = 0; i < this._catOffsets.length - 1; ++i) {
                        if (data[i] == 0.0) continue;
                        ival = (int)data[i] - 1;
                        if ((double)ival != data[i] - 1.0) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                        int n = c + 1;
                        preds[n] = preds[n] + this._beta[ival + c * this.P];
                    }
                } else {
                    for (i = 0; i < this._catOffsets.length - 1; ++i) {
                        ival = (int)data[i];
                        if ((double)ival != data[i]) {
                            throw new IllegalArgumentException("categorical value out of range");
                        }
                        if ((ival += this._catOffsets[i]) >= this._catOffsets[i + 1]) continue;
                        int n = c + 1;
                        preds[n] = preds[n] + this._beta[ival + c * this.P];
                    }
                }
            }
            for (i = 0; i < this._nums; ++i) {
                int n = c + 1;
                preds[n] = preds[n] + this._beta[this.noff + i + c * this.P] * data[i];
            }
            int n = c + 1;
            preds[n] = preds[n] + this._beta[this.P - 1 + c * this.P];
        }
        double max_row = 0.0;
        for (int c = 1; c < preds.length; ++c) {
            if (!(preds[c] > max_row)) continue;
            max_row = preds[c];
        }
        double sum_exp = 0.0;
        for (int c = 1; c < preds.length; ++c) {
            preds[c] = Math.exp(preds[c] - max_row);
            sum_exp += preds[c];
        }
        sum_exp = 1.0 / sum_exp;
        double max_p = 0.0;
        for (int c = 1; c < preds.length; ++c) {
            int n = c;
            double d = preds[n] = preds[n] * sum_exp;
            if (!(d > max_p)) continue;
            max_p = preds[c];
            preds[0] = c - 1;
        }
        return preds;
    }
}

