/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import java.io.PrintStream;
import java.util.ArrayList;

class SharedTreeSubgraph {
    private final int subgraphNumber;
    private final String name;
    private SharedTreeNode rootNode;
    private ArrayList<SharedTreeNode> nodesArray;

    SharedTreeSubgraph(int sn, String n) {
        this.subgraphNumber = sn;
        this.name = n;
        this.nodesArray = new ArrayList();
    }

    SharedTreeNode makeRootNode() {
        SharedTreeNode n = new SharedTreeNode(null, this.subgraphNumber, 0);
        n.setInclusiveNa(true);
        this.nodesArray.add(n);
        this.rootNode = n;
        return n;
    }

    SharedTreeNode makeLeftChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeLeftEdge(parent, child);
        return child;
    }

    SharedTreeNode makeRightChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeRightEdge(parent, child);
        return child;
    }

    private void makeLeftEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setLeftChild(child);
    }

    private void makeRightEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setRightChild(child);
    }

    void print() {
        System.out.println("");
        System.out.println("    ----- " + this.name + " -----");
        System.out.println("    Nodes");
        for (SharedTreeNode n : this.nodesArray) {
            n.print();
        }
        System.out.println("");
        System.out.println("    Edges");
        this.rootNode.printEdges();
    }

    void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail) {
        os.println("");
        os.println("subgraph cluster_" + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int maxLevel = -1;
        for (SharedTreeNode n : this.nodesArray) {
            if (n.getDepth() <= maxLevel) continue;
            maxLevel = n.getDepth();
        }
        for (int level = 0; level <= maxLevel; ++level) {
            os.println("");
            os.println("/* Level " + level + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, level, detail);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode n : this.nodesArray) {
            n.printDotEdges(os, maxLevelsToPrintPerEdge);
        }
        os.println("");
        os.println("fontsize=40");
        os.println("label=\"" + this.name + "\"");
        os.println("}");
    }
}

