/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.drf.DrfMojoModel;
import hex.genmodel.algos.gbm.GbmMojoModel;
import hex.genmodel.algos.tree.SharedTreeGraph;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class PrintMojo {
    private GenModel genModel;
    private static boolean printRaw = false;
    private static int treeToPrint = -1;
    private static int maxLevelsToPrintPerEdge = 10;
    private static boolean detail = false;
    private static String outputFileName = null;

    public static void main(String[] args) {
        PrintMojo main = new PrintMojo();
        main.parseArgs(args);
        try {
            main.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    private void loadMojo(String modelName) throws IOException {
        this.genModel = MojoModel.load(modelName);
    }

    private static void usage() {
        System.out.println("Emit a human-consumable graph of a model for use with dot (graphviz).");
        System.out.println("The currently supported model types are DRF and GBM.");
        System.out.println("");
        System.out.println("Usage:  java [...java args...] hex.genmodel.tools.PrintMojo [--tree n] [--levels n] [-o outputFileName]");
        System.out.println("");
        System.out.println("    --tree          Tree number to print.");
        System.out.println("                    [default all]");
        System.out.println("");
        System.out.println("    --levels        Number of levels per edge to print.");
        System.out.println("                    [default " + maxLevelsToPrintPerEdge + "]");
        System.out.println("");
        System.out.println("    --detail        Specify to print additional detailed information like node numbers.");
        System.out.println("");
        System.out.println("    --input | -i    Input mojo file.");
        System.out.println("");
        System.out.println("    --output | -o   Output dot filename.");
        System.out.println("                    [default stdout]");
        System.out.println("");
        System.out.println("Example:");
        System.out.println("");
        System.out.println("    (brew install graphviz)");
        System.out.println("    java -cp h2o.jar hex.genmodel.tools.PrintMojo --tree 0 -i model_mojo.zip -o model.gv");
        System.out.println("    dot -Tpng model.gv -o model.png");
        System.out.println("    open model.png");
        System.out.println("");
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        try {
            block24: for (int i = 0; i < args.length; ++i) {
                String s;
                String string = s = args[i];
                int n = -1;
                switch (string.hashCode()) {
                    case 1333438782: {
                        if (!string.equals("--tree")) break;
                        n = 0;
                        break;
                    }
                    case 1293886223: {
                        if (!string.equals("--levels")) break;
                        n = 1;
                        break;
                    }
                    case 1064789489: {
                        if (!string.equals("--detail")) break;
                        n = 2;
                        break;
                    }
                    case -1623337430: {
                        if (!string.equals("--input")) break;
                        n = 3;
                        break;
                    }
                    case 1500: {
                        if (!string.equals("-i")) break;
                        n = 4;
                        break;
                    }
                    case 43011720: {
                        if (!string.equals("--raw")) break;
                        n = 5;
                        break;
                    }
                    case 1506: {
                        if (!string.equals("-o")) break;
                        n = 6;
                        break;
                    }
                    case 1394501281: {
                        if (!string.equals("--output")) break;
                        n = 7;
                    }
                }
                switch (n) {
                    case 0: {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        try {
                            treeToPrint = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            System.out.println("ERROR: invalid --tree argument (" + s + ")");
                            System.exit(1);
                        }
                        continue block24;
                    }
                    case 1: {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        try {
                            maxLevelsToPrintPerEdge = Integer.parseInt(s);
                        }
                        catch (Exception e) {
                            System.out.println("ERROR: invalid --levels argument (" + s + ")");
                            System.exit(1);
                        }
                        continue block24;
                    }
                    case 2: {
                        detail = true;
                        continue block24;
                    }
                    case 3: 
                    case 4: {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        s = args[i];
                        this.loadMojo(s);
                        continue block24;
                    }
                    case 5: {
                        printRaw = true;
                        continue block24;
                    }
                    case 6: 
                    case 7: {
                        if (++i >= args.length) {
                            PrintMojo.usage();
                        }
                        outputFileName = args[i];
                        continue block24;
                    }
                    default: {
                        System.out.println("ERROR: Unknown command line argument: " + s);
                        PrintMojo.usage();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PrintMojo.usage();
        }
    }

    private void validateArgs() {
        if (this.genModel == null) {
            System.out.println("ERROR: Must specify -i");
            PrintMojo.usage();
        }
    }

    private void run() throws Exception {
        this.validateArgs();
        PrintStream os = outputFileName != null ? new PrintStream(new FileOutputStream(new File(outputFileName))) : System.out;
        if (this.genModel instanceof GbmMojoModel) {
            SharedTreeGraph g = ((GbmMojoModel)this.genModel)._computeGraph(treeToPrint);
            if (printRaw) {
                g.print();
            }
            g.printDot(os, maxLevelsToPrintPerEdge, detail);
        } else if (this.genModel instanceof DrfMojoModel) {
            SharedTreeGraph g = ((DrfMojoModel)this.genModel)._computeGraph(treeToPrint);
            if (printRaw) {
                g.print();
            }
            g.printDot(os, maxLevelsToPrintPerEdge, detail);
        } else {
            System.out.println("ERROR: Unknown MOJO type");
            System.exit(1);
        }
    }
}

