/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.deepwater.DeepwaterMojoReader;
import hex.genmodel.algos.drf.DrfMojoReader;
import hex.genmodel.algos.gbm.GbmMojoReader;
import hex.genmodel.algos.glm.GlmMojoReader;
import hex.genmodel.algos.glrm.GlrmMojoReader;
import hex.genmodel.algos.word2vec.Word2VecMojoReader;

public class ModelMojoFactory {
    public static ModelMojoReader getMojoReader(String algo) {
        if (algo == null) {
            throw new IllegalArgumentException("Algorithm not specified.");
        }
        String string = algo;
        int n = -1;
        switch (string.hashCode()) {
            case 688225085: {
                if (!string.equals("Distributed Random Forest")) break;
                n = 0;
                break;
            }
            case 2021240306: {
                if (!string.equals("Gradient Boosting Method")) break;
                n = 1;
                break;
            }
            case -1896281770: {
                if (!string.equals("Gradient Boosting Machine")) break;
                n = 2;
                break;
            }
            case -1096458013: {
                if (!string.equals("Deep Water")) break;
                n = 3;
                break;
            }
            case -2117985831: {
                if (!string.equals("Generalized Low Rank Modeling")) break;
                n = 4;
                break;
            }
            case -495150743: {
                if (!string.equals("Generalized Low Rank Model")) break;
                n = 5;
                break;
            }
            case -453598996: {
                if (!string.equals("Generalized Linear Modeling")) break;
                n = 6;
                break;
            }
            case -71523530: {
                if (!string.equals("Generalized Linear Model")) break;
                n = 7;
                break;
            }
            case 91988012: {
                if (!string.equals("Word2Vec")) break;
                n = 8;
            }
        }
        switch (n) {
            case 0: {
                return new DrfMojoReader();
            }
            case 1: 
            case 2: {
                return new GbmMojoReader();
            }
            case 3: {
                return new DeepwaterMojoReader();
            }
            case 4: 
            case 5: {
                return new GlrmMojoReader();
            }
            case 6: 
            case 7: {
                return new GlmMojoReader();
            }
            case 8: {
                return new Word2VecMojoReader();
            }
        }
        throw new IllegalStateException("Unsupported MOJO algorithm: " + algo);
    }
}

