/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.utils.GenmodelBitSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;

class SharedTreeNode {
    final SharedTreeNode parent;
    final int subgraphNumber;
    int nodeNumber;
    float weight;
    final int depth;
    int colId;
    String colName;
    boolean leftward;
    boolean naVsRest;
    float splitValue = Float.NaN;
    String[] domainValues;
    GenmodelBitSet bs;
    float predValue = Float.NaN;
    float squaredError = Float.NaN;
    SharedTreeNode leftChild;
    SharedTreeNode rightChild;
    private boolean inclusiveNa;
    private BitSet inclusiveLevels;

    SharedTreeNode(SharedTreeNode p, int sn, int d) {
        this.parent = p;
        this.subgraphNumber = sn;
        this.depth = d;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    float getWeight() {
        return this.weight;
    }

    void setNodeNumber(int id) {
        this.nodeNumber = id;
    }

    void setWeight(float w) {
        this.weight = w;
    }

    void setCol(int v1, String v2) {
        this.colId = v1;
        this.colName = v2;
    }

    private int getColId() {
        return this.colId;
    }

    void setLeftward(boolean v) {
        this.leftward = v;
    }

    void setNaVsRest(boolean v) {
        this.naVsRest = v;
    }

    void setSplitValue(float v) {
        this.splitValue = v;
    }

    void setBitset(String[] v1, GenmodelBitSet v2) {
        assert (v1 != null);
        this.domainValues = v1;
        this.bs = v2;
    }

    void setPredValue(float v) {
        this.predValue = v;
    }

    void setSquaredError(float v) {
        this.squaredError = v;
    }

    private boolean findInclusiveNa(int colIdToFind) {
        if (this.parent == null) {
            return true;
        }
        if (this.parent.getColId() == colIdToFind) {
            return this.inclusiveNa;
        }
        return this.parent.findInclusiveNa(colIdToFind);
    }

    private boolean calculateChildInclusiveNa(boolean includeThisSplitEdge) {
        return this.findInclusiveNa(this.colId) && includeThisSplitEdge;
    }

    private BitSet findInclusiveLevels(int colIdToFind) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getColId() == colIdToFind) {
            return this.inclusiveLevels;
        }
        return this.parent.findInclusiveLevels(colIdToFind);
    }

    private boolean calculateIncludeThisLevel(BitSet inheritedInclusiveLevels, int i) {
        if (inheritedInclusiveLevels == null) {
            return true;
        }
        return inheritedInclusiveLevels.get(i);
    }

    private BitSet calculateChildInclusiveLevels(boolean includeAllLevels, boolean discardAllLevels, boolean nodeBitsetDoesContain) {
        BitSet inheritedInclusiveLevels = this.findInclusiveLevels(this.colId);
        BitSet childInclusiveLevels = new BitSet();
        for (int i = 0; i < this.domainValues.length; ++i) {
            boolean includeThisLevel = false;
            if (discardAllLevels) {
                includeThisLevel = false;
            } else if (includeAllLevels) {
                includeThisLevel = this.calculateIncludeThisLevel(inheritedInclusiveLevels, i);
            } else if (this.bs.isInRange(i) && this.bs.contains(i) == nodeBitsetDoesContain) {
                includeThisLevel = this.calculateIncludeThisLevel(inheritedInclusiveLevels, i);
            }
            if (!includeThisLevel) continue;
            childInclusiveLevels.set(i);
        }
        return childInclusiveLevels;
    }

    void setLeftChild(SharedTreeNode v) {
        this.leftChild = v;
        boolean childInclusiveNa = this.calculateChildInclusiveNa(this.leftward);
        v.setInclusiveNa(childInclusiveNa);
        if (!this.isBitset()) {
            return;
        }
        BitSet childInclusiveLevels = this.calculateChildInclusiveLevels(this.naVsRest, false, false);
        v.setInclusiveLevels(childInclusiveLevels);
    }

    void setRightChild(SharedTreeNode v) {
        this.rightChild = v;
        boolean childInclusiveNa = this.calculateChildInclusiveNa(!this.leftward);
        v.setInclusiveNa(childInclusiveNa);
        if (!this.isBitset()) {
            return;
        }
        BitSet childInclusiveLevels = this.calculateChildInclusiveLevels(false, this.naVsRest, true);
        v.setInclusiveLevels(childInclusiveLevels);
    }

    void setInclusiveNa(boolean v) {
        this.inclusiveNa = v;
    }

    private boolean getInclusiveNa() {
        return this.inclusiveNa;
    }

    private void setInclusiveLevels(BitSet v) {
        this.inclusiveLevels = v;
    }

    private BitSet getInclusiveLevels() {
        return this.inclusiveLevels;
    }

    public String getName() {
        return "Node " + this.nodeNumber;
    }

    public void print() {
        System.out.println("        Node " + this.nodeNumber);
        System.out.println("            weight:      " + this.weight);
        System.out.println("            depth:       " + this.depth);
        System.out.println("            colId:       " + this.colId);
        System.out.println("            colName:     " + (this.colName != null ? this.colName : ""));
        System.out.println("            leftward:    " + this.leftward);
        System.out.println("            naVsRest:    " + this.naVsRest);
        System.out.println("            splitVal:    " + this.splitValue);
        System.out.println("            isBitset:    " + this.isBitset());
        System.out.println("            predValue:   " + this.predValue);
        System.out.println("            squaredErr:  " + this.squaredError);
        System.out.println("            leftChild:   " + (this.leftChild != null ? this.leftChild.getName() : ""));
        System.out.println("            rightChild:  " + (this.rightChild != null ? this.rightChild.getName() : ""));
    }

    void printEdges() {
        if (this.leftChild != null) {
            System.out.println("        " + this.getName() + " ---left---> " + this.leftChild.getName());
            this.leftChild.printEdges();
        }
        if (this.rightChild != null) {
            System.out.println("        " + this.getName() + " ---right--> " + this.rightChild.getName());
            this.rightChild.printEdges();
        }
    }

    private String getDotName() {
        return "SG_" + this.subgraphNumber + "_Node_" + this.nodeNumber;
    }

    private boolean isBitset() {
        return this.domainValues != null;
    }

    public static String escapeQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    private void printDotNode(PrintStream os, boolean detail) {
        os.print("\"" + this.getDotName() + "\"");
        os.print(" [");
        if (this.leftChild == null && this.rightChild == null) {
            os.print("label=\"");
            os.print(this.predValue);
        } else if (this.isBitset()) {
            os.print("shape=box,label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName));
        } else {
            assert (!Float.isNaN(this.splitValue));
            os.print("shape=box,label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName) + " < " + this.splitValue);
        }
        if (detail) {
            os.print("\\n\\nN" + this.getNodeNumber() + "\\n");
            if (!(this.leftChild == null && this.rightChild == null || Float.isNaN(this.predValue))) {
                os.print("\\nPred: " + this.predValue);
            }
            if (!Float.isNaN(this.squaredError)) {
                os.print("\\nSE: " + this.squaredError);
            }
            os.print("\\nW: " + this.getWeight());
            if (this.naVsRest) {
                os.print("\\nnasVsRest");
            }
            if (this.leftChild != null) {
                os.print("\\nL: N" + this.leftChild.getNodeNumber());
            }
            if (this.rightChild != null) {
                os.print("\\nR: N" + this.rightChild.getNodeNumber());
            }
        }
        os.print("\"]");
        os.println("");
    }

    void printDotNodesAtLevel(PrintStream os, int levelToPrint, boolean detail) {
        if (this.getDepth() == levelToPrint) {
            this.printDotNode(os, detail);
            return;
        }
        assert (this.getDepth() < levelToPrint);
        if (this.leftChild != null) {
            this.leftChild.printDotNodesAtLevel(os, levelToPrint, detail);
        }
        if (this.rightChild != null) {
            this.rightChild.printDotNodesAtLevel(os, levelToPrint, detail);
        }
    }

    private void printDotEdgesCommon(PrintStream os, int maxLevelsToPrintPerEdge, ArrayList<String> arr, SharedTreeNode child) {
        if (this.isBitset()) {
            BitSet childInclusiveLevels = child.getInclusiveLevels();
            int total = childInclusiveLevels.cardinality();
            if (total > 0 && total <= maxLevelsToPrintPerEdge) {
                int i = childInclusiveLevels.nextSetBit(0);
                while (i >= 0) {
                    arr.add(this.domainValues[i]);
                    i = childInclusiveLevels.nextSetBit(i + 1);
                }
            } else {
                arr.add(total + " levels");
            }
        }
        os.print("label=\"");
        for (String s : arr) {
            os.print(SharedTreeNode.escapeQuotes(s) + "\\n");
        }
        os.print("\"");
        os.println("]");
    }

    void printDotEdges(PrintStream os, int maxLevelsToPrintPerEdge) {
        ArrayList<String> arr;
        assert (this.leftChild == null == (this.rightChild == null));
        if (this.leftChild != null) {
            os.print("\"" + this.getDotName() + "\"" + " -> " + "\"" + this.leftChild.getDotName() + "\"" + " [");
            arr = new ArrayList<String>();
            if (this.leftChild.getInclusiveNa()) {
                arr.add("[NA]");
            }
            if (this.naVsRest) {
                arr.add("[Not NA]");
            } else if (!this.isBitset()) {
                arr.add("<");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arr, this.leftChild);
        }
        if (this.rightChild != null) {
            os.print("\"" + this.getDotName() + "\"" + " -> " + "\"" + this.rightChild.getDotName() + "\"" + " [");
            arr = new ArrayList();
            if (this.rightChild.getInclusiveNa()) {
                arr.add("[NA]");
            }
            if (!this.naVsRest && !this.isBitset()) {
                arr.add(">=");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arr, this.rightChild);
        }
    }
}

