/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.deeplearning;

import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.deeplearning.DeeplearningMojoModel;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;

public class DeeplearningMojoReader
extends ModelMojoReader<DeeplearningMojoModel> {
    @Override
    public String getModelName() {
        return "Deep Learning";
    }

    @Override
    protected void readModelData() throws IOException {
        ((DeeplearningMojoModel)this._model)._mini_batch_size = (Integer)this.readkv("mini_batch_size");
        ((DeeplearningMojoModel)this._model)._nums = (Integer)this.readkv("nums");
        ((DeeplearningMojoModel)this._model)._cats = (Integer)this.readkv("cats");
        ((DeeplearningMojoModel)this._model)._catoffsets = this.readkv("cat_offsets", new int[0]);
        ((DeeplearningMojoModel)this._model)._normmul = this.readkv("norm_mul", new double[0]);
        ((DeeplearningMojoModel)this._model)._normsub = this.readkv("norm_sub", new double[0]);
        ((DeeplearningMojoModel)this._model)._normrespmul = (double[])this.readkv("norm_resp_mul");
        ((DeeplearningMojoModel)this._model)._normrespsub = (double[])this.readkv("norm_resp_sub");
        ((DeeplearningMojoModel)this._model)._use_all_factor_levels = (Boolean)this.readkv("use_all_factor_levels");
        ((DeeplearningMojoModel)this._model)._activation = (String)this.readkv("activation");
        ((DeeplearningMojoModel)this._model)._imputeMeans = (Boolean)this.readkv("mean_imputation");
        ((DeeplearningMojoModel)this._model)._family = DistributionFamily.valueOf((String)this.readkv("distribution"));
        if (((DeeplearningMojoModel)this._model)._imputeMeans & ((DeeplearningMojoModel)this._model)._cats > 0) {
            ((DeeplearningMojoModel)this._model)._catNAFill = this.readkv("cat_modes", new int[0]);
        }
        ((DeeplearningMojoModel)this._model)._units = this.readkv("neural_network_sizes", new int[0]);
        ((DeeplearningMojoModel)this._model)._all_drop_out_ratios = this.readkv("hidden_dropout_ratios", new double[0]);
        int numLayers = ((DeeplearningMojoModel)this._model)._units.length - 1;
        ((DeeplearningMojoModel)this._model)._weightsAndBias = new DeeplearningMojoModel.StoreWeightsBias[numLayers];
        for (int layerIndex = 0; layerIndex < numLayers; ++layerIndex) {
            double[] tempB = this.readkv("bias_layer" + layerIndex, new double[0]);
            double[] tempWD = this.readkv("weight_layer" + layerIndex, new double[0]);
            float[] tempW = tempWD.length == 0 ? new float[]{} : GenModel.convertDouble2Float(tempWD);
            ((DeeplearningMojoModel)this._model)._weightsAndBias[layerIndex] = new DeeplearningMojoModel.StoreWeightsBias(tempW, tempB);
        }
        ((DeeplearningMojoModel)this._model).init();
    }

    @Override
    protected DeeplearningMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new DeeplearningMojoModel(columns, domains, responseColumn);
    }
}

