/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy.error;

import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class CountingErrorConsumer
extends EasyPredictModelWrapper.ErrorConsumer {
    private Map<String, AtomicLong> dataTransformationErrorsCountPerColumn;
    private Map<String, AtomicLong> unknownCategoricalsPerColumn;

    public CountingErrorConsumer(GenModel model) {
        this.initializeDataTransformationErrorsCount(model);
        this.initializeUnknownCategoricalsPerColumn(model);
    }

    private void initializeDataTransformationErrorsCount(GenModel model) {
        String responseColumnName = model.isSupervised() ? model.getResponseName() : null;
        this.dataTransformationErrorsCountPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        for (String column : model.getNames()) {
            if (model.isSupervised() && column.equals(responseColumnName)) continue;
            this.dataTransformationErrorsCountPerColumn.put(column, new AtomicLong());
        }
        this.dataTransformationErrorsCountPerColumn = Collections.unmodifiableMap(this.dataTransformationErrorsCountPerColumn);
    }

    private void initializeUnknownCategoricalsPerColumn(GenModel model) {
        this.unknownCategoricalsPerColumn = new ConcurrentHashMap<String, AtomicLong>();
        for (int i = 0; i < model.getNumCols(); ++i) {
            String[] domainValues = model.getDomainValues(i);
            if (domainValues == null) continue;
            this.unknownCategoricalsPerColumn.put(model.getNames()[i], new AtomicLong());
        }
        this.unknownCategoricalsPerColumn = Collections.unmodifiableMap(this.unknownCategoricalsPerColumn);
    }

    @Override
    public void dataTransformError(String columnName, Object value, String message) {
        this.dataTransformationErrorsCountPerColumn.get(columnName).incrementAndGet();
    }

    @Override
    public void unseenCategorical(String columnName, Object value, String message) {
        this.unknownCategoricalsPerColumn.get(columnName).incrementAndGet();
    }

    public long getTotalUnknownCategoricalLevelsSeen() {
        long total = 0L;
        for (AtomicLong l : this.unknownCategoricalsPerColumn.values()) {
            total += l.get();
        }
        return total;
    }

    public Map<String, AtomicLong> getUnknownCategoricalsPerColumn() {
        return this.unknownCategoricalsPerColumn;
    }

    public Map<String, AtomicLong> getDataTransformationErrorsCountPerColumn() {
        return this.dataTransformationErrorsCountPerColumn;
    }

    public long getDataTransformationErrorsCount() {
        long total = 0L;
        for (AtomicLong l : this.dataTransformationErrorsCountPerColumn.values()) {
            total += l.get();
        }
        return total;
    }
}

