/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.drf;

import hex.genmodel.GenModel;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import hex.genmodel.algos.tree.SharedTreeMojoModel;

public final class DrfMojoModel
extends SharedTreeMojoModel
implements SharedTreeGraphConverter {
    protected boolean _binomial_double_trees;

    public DrfMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public final double[] score0(double[] row, double offset, double[] preds) {
        super.scoreAllTrees(row, preds);
        return this.unifyPreds(row, offset, preds);
    }

    @Override
    public final double[] unifyPreds(double[] row, double offset, double[] preds) {
        if (this._nclasses == 1) {
            preds[0] = preds[0] / (double)this._ntree_groups;
        } else {
            if (this._nclasses == 2 && !this._binomial_double_trees) {
                preds[1] = preds[1] / (double)this._ntree_groups;
                preds[2] = 1.0 - preds[1];
            } else {
                int i;
                double sum = 0.0;
                for (i = 1; i <= this._nclasses; ++i) {
                    sum += preds[i];
                }
                if (sum > 0.0) {
                    i = 1;
                    while (i <= this._nclasses) {
                        int n = i++;
                        preds[n] = preds[n] / sum;
                    }
                }
            }
            if (this._balanceClasses) {
                GenModel.correctProbabilities(preds, this._priorClassDistrib, this._modelClassDistrib);
            }
            preds[0] = GenModel.getPrediction(preds, this._priorClassDistrib, row, this._defaultThreshold);
        }
        return preds;
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }
}

