/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.tools.PrintMojo;
import hex.genmodel.utils.GenmodelBitSet;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;

public class SharedTreeNode {
    final SharedTreeNode parent;
    final int subgraphNumber;
    int nodeNumber;
    float weight;
    final int depth;
    int colId;
    String colName;
    boolean leftward;
    boolean naVsRest;
    float splitValue = Float.NaN;
    String[] domainValues;
    GenmodelBitSet bs;
    float predValue = Float.NaN;
    float squaredError = Float.NaN;
    SharedTreeNode leftChild;
    public SharedTreeNode rightChild;
    private boolean inclusiveNa;
    private BitSet inclusiveLevels;

    SharedTreeNode(SharedTreeNode p, int sn, int d) {
        this.parent = p;
        this.subgraphNumber = sn;
        this.depth = d;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getNodeNumber() {
        return this.nodeNumber;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setNodeNumber(int id) {
        this.nodeNumber = id;
    }

    void setWeight(float w) {
        this.weight = w;
    }

    public void setCol(int v1, String v2) {
        this.colId = v1;
        this.colName = v2;
    }

    private int getColId() {
        return this.colId;
    }

    public void setLeftward(boolean v) {
        this.leftward = v;
    }

    void setNaVsRest(boolean v) {
        this.naVsRest = v;
    }

    public void setSplitValue(float v) {
        this.splitValue = v;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    void setBitset(String[] v1, GenmodelBitSet v2) {
        assert (v1 != null);
        this.domainValues = v1;
        this.bs = v2;
    }

    public void setPredValue(float v) {
        this.predValue = v;
    }

    public void setSquaredError(float v) {
        this.squaredError = v;
    }

    private boolean findInclusiveNa(int colIdToFind) {
        if (this.parent == null) {
            return true;
        }
        if (this.parent.getColId() == colIdToFind) {
            return this.inclusiveNa;
        }
        return this.parent.findInclusiveNa(colIdToFind);
    }

    private boolean calculateChildInclusiveNa(boolean includeThisSplitEdge) {
        return this.findInclusiveNa(this.colId) && includeThisSplitEdge;
    }

    private BitSet findInclusiveLevels(int colIdToFind) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getColId() == colIdToFind) {
            return this.inclusiveLevels;
        }
        return this.parent.findInclusiveLevels(colIdToFind);
    }

    private boolean calculateIncludeThisLevel(BitSet inheritedInclusiveLevels, int i) {
        if (inheritedInclusiveLevels == null) {
            return true;
        }
        return inheritedInclusiveLevels.get(i);
    }

    private BitSet calculateChildInclusiveLevels(boolean includeAllLevels, boolean discardAllLevels, boolean nodeBitsetDoesContain) {
        BitSet inheritedInclusiveLevels = this.findInclusiveLevels(this.colId);
        BitSet childInclusiveLevels = new BitSet();
        for (int i = 0; i < this.domainValues.length; ++i) {
            boolean includeThisLevel = false;
            if (discardAllLevels) {
                includeThisLevel = false;
            } else if (includeAllLevels) {
                includeThisLevel = this.calculateIncludeThisLevel(inheritedInclusiveLevels, i);
            } else if (this.bs.isInRange(i) && this.bs.contains(i) == nodeBitsetDoesContain) {
                includeThisLevel = this.calculateIncludeThisLevel(inheritedInclusiveLevels, i);
            }
            if (!includeThisLevel) continue;
            childInclusiveLevels.set(i);
        }
        return childInclusiveLevels;
    }

    void setLeftChild(SharedTreeNode v) {
        this.leftChild = v;
        boolean childInclusiveNa = this.calculateChildInclusiveNa(this.leftward);
        v.setInclusiveNa(childInclusiveNa);
        if (!this.isBitset()) {
            return;
        }
        BitSet childInclusiveLevels = this.calculateChildInclusiveLevels(this.naVsRest, false, false);
        v.setInclusiveLevels(childInclusiveLevels);
    }

    void setRightChild(SharedTreeNode v) {
        this.rightChild = v;
        boolean childInclusiveNa = this.calculateChildInclusiveNa(!this.leftward);
        v.setInclusiveNa(childInclusiveNa);
        if (!this.isBitset()) {
            return;
        }
        BitSet childInclusiveLevels = this.calculateChildInclusiveLevels(false, this.naVsRest, true);
        v.setInclusiveLevels(childInclusiveLevels);
    }

    public void setInclusiveNa(boolean v) {
        this.inclusiveNa = v;
    }

    public boolean getInclusiveNa() {
        return this.inclusiveNa;
    }

    private void setInclusiveLevels(BitSet v) {
        this.inclusiveLevels = v;
    }

    public BitSet getInclusiveLevels() {
        return this.inclusiveLevels;
    }

    public String getName() {
        return "Node " + this.nodeNumber;
    }

    public void print() {
        this.print(System.out, null);
    }

    public void print(PrintStream out, String description) {
        out.println("        Node " + this.nodeNumber + (description != null ? " (" + description + ")" : ""));
        out.println("            weight:      " + this.weight);
        out.println("            depth:       " + this.depth);
        out.println("            colId:       " + this.colId);
        out.println("            colName:     " + (this.colName != null ? this.colName : ""));
        out.println("            leftward:    " + this.leftward);
        out.println("            naVsRest:    " + this.naVsRest);
        out.println("            splitVal:    " + this.splitValue);
        out.println("            isBitset:    " + this.isBitset());
        out.println("            predValue:   " + this.predValue);
        out.println("            squaredErr:  " + this.squaredError);
        out.println("            leftChild:   " + (this.leftChild != null ? this.leftChild.getName() : ""));
        out.println("            rightChild:  " + (this.rightChild != null ? this.rightChild.getName() : ""));
    }

    void printEdges() {
        if (this.leftChild != null) {
            System.out.println("        " + this.getName() + " ---left---> " + this.leftChild.getName());
            this.leftChild.printEdges();
        }
        if (this.rightChild != null) {
            System.out.println("        " + this.getName() + " ---right--> " + this.rightChild.getName());
            this.rightChild.printEdges();
        }
    }

    private String getDotName() {
        return "SG_" + this.subgraphNumber + "_Node_" + this.nodeNumber;
    }

    public boolean isBitset() {
        return this.domainValues != null;
    }

    public static String escapeQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    private void printDotNode(PrintStream os, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        float predv;
        os.print("\"" + this.getDotName() + "\"");
        os.print(" [");
        if (this.leftChild == null && this.rightChild == null) {
            os.print("fontsize=" + treeOptions._fontSize + ", label=\"");
            predv = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.predValue) : this.predValue;
            os.print(predv);
        } else if (this.isBitset()) {
            os.print("shape=box, fontsize=" + treeOptions._fontSize + ", label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName));
        } else {
            assert (!Float.isNaN(this.splitValue));
            float splitV = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.splitValue) : this.splitValue;
            os.print("shape=box, fontsize=" + treeOptions._fontSize + ", label=\"");
            os.print(SharedTreeNode.escapeQuotes(this.colName) + " < " + splitV);
        }
        if (detail) {
            os.print("\\n\\nN" + this.getNodeNumber() + "\\n");
            if (!(this.leftChild == null && this.rightChild == null || Float.isNaN(this.predValue))) {
                predv = treeOptions._setDecimalPlace ? treeOptions.roundNPlace(this.predValue) : this.predValue;
                os.print("\\nPred: " + predv);
            }
            if (!Float.isNaN(this.squaredError)) {
                os.print("\\nSE: " + this.squaredError);
            }
            os.print("\\nW: " + this.getWeight());
            if (this.naVsRest) {
                os.print("\\nnasVsRest");
            }
            if (this.leftChild != null) {
                os.print("\\nL: N" + this.leftChild.getNodeNumber());
            }
            if (this.rightChild != null) {
                os.print("\\nR: N" + this.rightChild.getNodeNumber());
            }
        }
        os.print("\"]");
        os.println("");
    }

    void printDotNodesAtLevel(PrintStream os, int levelToPrint, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        if (this.getDepth() == levelToPrint) {
            this.printDotNode(os, detail, treeOptions);
            return;
        }
        assert (this.getDepth() < levelToPrint);
        if (this.leftChild != null) {
            this.leftChild.printDotNodesAtLevel(os, levelToPrint, detail, treeOptions);
        }
        if (this.rightChild != null) {
            this.rightChild.printDotNodesAtLevel(os, levelToPrint, detail, treeOptions);
        }
    }

    private void printDotEdgesCommon(PrintStream os, int maxLevelsToPrintPerEdge, ArrayList<String> arr, SharedTreeNode child, float totalWeight, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        if (this.isBitset()) {
            BitSet childInclusiveLevels = child.getInclusiveLevels();
            int total = childInclusiveLevels.cardinality();
            if (total > 0 && total <= maxLevelsToPrintPerEdge) {
                int i = childInclusiveLevels.nextSetBit(0);
                while (i >= 0) {
                    arr.add(this.domainValues[i]);
                    i = childInclusiveLevels.nextSetBit(i + 1);
                }
            } else {
                arr.add(total + " levels");
            }
        }
        if (detail) {
            try {
                int max_width = 14;
                float width = child.getWeight() / totalWeight * 14.0f;
                int intWidth = Math.round(width) + 1;
                os.print("penwidth=");
                os.print(intWidth);
                os.print(",");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        os.print("fontsize=" + treeOptions._fontSize + ", label=\"");
        for (String s : arr) {
            os.print(SharedTreeNode.escapeQuotes(s) + "\\n");
        }
        os.print("\"");
        os.println("]");
    }

    void printDotEdges(PrintStream os, int maxLevelsToPrintPerEdge, float totalWeight, boolean detail, PrintMojo.PrintTreeOptions treeOptions) {
        ArrayList<String> arr;
        assert (this.leftChild == null == (this.rightChild == null));
        if (this.leftChild != null) {
            os.print("\"" + this.getDotName() + "\" -> \"" + this.leftChild.getDotName() + "\" [");
            arr = new ArrayList<String>();
            if (this.leftChild.getInclusiveNa()) {
                arr.add("[NA]");
            }
            if (this.naVsRest) {
                arr.add("[Not NA]");
            } else if (!this.isBitset()) {
                arr.add("<");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arr, this.leftChild, totalWeight, detail, treeOptions);
        }
        if (this.rightChild != null) {
            os.print("\"" + this.getDotName() + "\" -> \"" + this.rightChild.getDotName() + "\" [");
            arr = new ArrayList();
            if (this.rightChild.getInclusiveNa()) {
                arr.add("[NA]");
            }
            if (!this.naVsRest && !this.isBitset()) {
                arr.add(">=");
            }
            this.printDotEdgesCommon(os, maxLevelsToPrintPerEdge, arr, this.rightChild, totalWeight, detail, treeOptions);
        }
    }

    public SharedTreeNode getParent() {
        return this.parent;
    }

    public int getSubgraphNumber() {
        return this.subgraphNumber;
    }

    public String getColName() {
        return this.colName;
    }

    public boolean isLeftward() {
        return this.leftward;
    }

    public boolean isNaVsRest() {
        return this.naVsRest;
    }

    public float getSplitValue() {
        return this.splitValue;
    }

    public String[] getDomainValues() {
        return this.domainValues;
    }

    public void setDomainValues(String[] domainValues) {
        this.domainValues = domainValues;
    }

    public GenmodelBitSet getBs() {
        return this.bs;
    }

    public float getPredValue() {
        return this.predValue;
    }

    public float getSquaredError() {
        return this.squaredError;
    }

    public SharedTreeNode getLeftChild() {
        return this.leftChild;
    }

    public SharedTreeNode getRightChild() {
        return this.rightChild;
    }

    public boolean isInclusiveNa() {
        return this.inclusiveNa;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedTreeNode that = (SharedTreeNode)o;
        return this.subgraphNumber == that.subgraphNumber && this.nodeNumber == that.nodeNumber && Float.compare(that.weight, this.weight) == 0 && this.depth == that.depth && this.colId == that.colId && this.leftward == that.leftward && this.naVsRest == that.naVsRest && Float.compare(that.splitValue, this.splitValue) == 0 && Float.compare(that.predValue, this.predValue) == 0 && Float.compare(that.squaredError, this.squaredError) == 0 && this.inclusiveNa == that.inclusiveNa && Objects.equals(this.colName, that.colName) && Arrays.equals(this.domainValues, that.domainValues) && Objects.equals(this.leftChild, that.leftChild) && Objects.equals(this.rightChild, that.rightChild) && Objects.equals(this.inclusiveLevels, that.inclusiveLevels);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphNumber, this.nodeNumber);
    }
}

