/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import com.google.gson.JsonObject;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.descriptor.JsonModelDescriptorReader;
import hex.genmodel.descriptor.ModelDescriptorBuilder;
import hex.genmodel.descriptor.Table;
import hex.genmodel.descriptor.VariableImportances;
import java.io.IOException;
import java.util.Arrays;

public abstract class SharedTreeMojoReader<M extends SharedTreeMojoModel>
extends ModelMojoReader<M> {
    @Override
    protected void readModelData() throws IOException {
        Integer tpc = (Integer)this.readkv("n_trees_per_class");
        if (tpc == null) {
            Boolean bdt = (Boolean)this.readkv("binomial_double_trees");
            tpc = ((SharedTreeMojoModel)this._model).nclasses() == 2 && (bdt == null || bdt == false) ? 1 : ((SharedTreeMojoModel)this._model).nclasses();
        }
        ((SharedTreeMojoModel)this._model)._ntree_groups = (Integer)this.readkv("n_trees");
        ((SharedTreeMojoModel)this._model)._ntrees_per_group = tpc;
        ((SharedTreeMojoModel)this._model)._compressed_trees = new byte[((SharedTreeMojoModel)this._model)._ntree_groups * tpc][];
        ((SharedTreeMojoModel)this._model)._mojo_version = ((Number)this.readkv("mojo_version")).doubleValue();
        if (((SharedTreeMojoModel)this._model)._mojo_version > 1.0) {
            ((SharedTreeMojoModel)this._model)._compressed_trees_aux = new byte[((SharedTreeMojoModel)this._model)._ntree_groups * tpc][];
        }
        for (int j = 0; j < ((SharedTreeMojoModel)this._model)._ntree_groups; ++j) {
            for (int i = 0; i < tpc; ++i) {
                String blobName = String.format("trees/t%02d_%03d.bin", i, j);
                if (!this.exists(blobName)) continue;
                ((SharedTreeMojoModel)this._model)._compressed_trees[((SharedTreeMojoModel)this._model).treeIndex((int)j, (int)i)] = this.readblob(blobName);
                if (((SharedTreeMojoModel)this._model)._compressed_trees_aux == null) continue;
                ((SharedTreeMojoModel)this._model)._compressed_trees_aux[((SharedTreeMojoModel)this._model).treeIndex((int)j, (int)i)] = this.readblob(String.format("trees/t%02d_%03d_aux.bin", i, j));
            }
        }
        String calibMethod = (String)this.readkv("calib_method");
        if (calibMethod != null) {
            if (!"platt".equals(calibMethod)) {
                throw new IllegalStateException("Unknown calibration method: " + calibMethod);
            }
            ((SharedTreeMojoModel)this._model)._calib_glm_beta = this.readkv("calib_glm_beta", new double[0]);
        }
        ((SharedTreeMojoModel)this._model).postInit();
    }

    @Override
    protected void readModelSpecificDescription(ModelDescriptorBuilder modelDescriptorBuilder, JsonObject modelJson) {
        modelDescriptorBuilder.variableImportances(this.extractVariableImportances(modelJson));
    }

    private VariableImportances extractVariableImportances(JsonObject modelJson) {
        Table table = JsonModelDescriptorReader.extractTableFromJson(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] relativeVarimps = new double[table.rows()];
        int column = table.findColumnIndex("Relative Importance");
        if (column == -1) {
            return null;
        }
        for (int i = 0; i < table.rows(); ++i) {
            relativeVarimps[i] = (Double)table.getCell(column, i);
        }
        return new VariableImportances(Arrays.copyOf(((SharedTreeMojoModel)this._model)._names, ((SharedTreeMojoModel)this._model).nfeatures()), relativeVarimps);
    }
}

