/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.MojoModel;
import hex.genmodel.algos.tree.NaSplitDir;
import hex.genmodel.algos.tree.ScoreTree;
import hex.genmodel.algos.tree.ScoreTree0;
import hex.genmodel.algos.tree.ScoreTree1;
import hex.genmodel.algos.tree.ScoreTree2;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.descriptor.VariableImportances;
import hex.genmodel.utils.ByteBufferWrapper;
import hex.genmodel.utils.GenmodelBitSet;
import java.util.Arrays;
import java.util.HashMap;

public abstract class SharedTreeMojoModel
extends MojoModel
implements SharedTreeGraphConverter {
    private static final int NsdNaVsRest = NaSplitDir.NAvsREST.value();
    private static final int NsdNaLeft = NaSplitDir.NALeft.value();
    private static final int NsdLeft = NaSplitDir.Left.value();
    private ScoreTree _scoreTree;
    protected int _ntree_groups;
    protected int _ntrees_per_group;
    protected byte[][] _compressed_trees;
    protected byte[][] _compressed_trees_aux;
    protected double[] _calib_glm_beta;
    protected VariableImportances _variable_importances;

    protected void postInit() {
        this._scoreTree = this._mojo_version == 1.0 ? new ScoreTree0() : (this._mojo_version == 1.1 ? new ScoreTree1() : new ScoreTree2());
    }

    public final int getNTreeGroups() {
        return this._ntree_groups;
    }

    public final int getNTreesPerGroup() {
        return this._ntrees_per_group;
    }

    @Deprecated
    public static double scoreTree0(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment) {
        return SharedTreeMojoModel.scoreTree0(tree, row, computeLeafAssignment);
    }

    @Deprecated
    public static double scoreTree1(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment) {
        return SharedTreeMojoModel.scoreTree1(tree, row, computeLeafAssignment);
    }

    @Deprecated
    public static double scoreTree(byte[] tree, double[] row, int nclasses, boolean computeLeafAssignment, String[][] domains) {
        return SharedTreeMojoModel.scoreTree(tree, row, computeLeafAssignment, domains);
    }

    public static double scoreTree(byte[] tree, double[] row, boolean computeLeafAssignment, String[][] domains) {
        int lmask;
        ByteBufferWrapper ab = new ByteBufferWrapper(tree);
        GenmodelBitSet bs = null;
        long bitsRight = 0L;
        int level = 0;
        do {
            double d;
            int nodeType = ab.get1U();
            char colId = ab.get2();
            if (colId == '\uffff') {
                if (computeLeafAssignment) {
                    return Double.longBitsToDouble(bitsRight |= (long)(1 << level));
                }
                return ab.get4f();
            }
            int naSplitDir = ab.get1U();
            boolean naVsRest = naSplitDir == NsdNaVsRest;
            boolean leftward = naSplitDir == NsdNaLeft || naSplitDir == NsdLeft;
            lmask = nodeType & 0x33;
            int equal = nodeType & 0xC;
            assert (equal != 4);
            float splitVal = -1.0f;
            if (!naVsRest) {
                if (equal == 0) {
                    splitVal = ab.get4f();
                } else {
                    if (bs == null) {
                        bs = new GenmodelBitSet(0);
                    }
                    if (equal == 8) {
                        bs.fill2(tree, ab);
                    } else {
                        bs.fill3(tree, ab);
                    }
                }
            }
            if (Double.isNaN(d = row[colId]) || equal != 0 && bs != null && !bs.isInRange((int)d) || domains != null && domains[colId] != null && domains[colId].length <= (int)d ? !leftward : !naVsRest && (equal == 0 ? d >= (double)splitVal : bs.contains((int)d))) {
                switch (lmask) {
                    case 0: {
                        ab.skip(ab.get1U());
                        break;
                    }
                    case 1: {
                        ab.skip(ab.get2());
                        break;
                    }
                    case 2: {
                        ab.skip(ab.get3());
                        break;
                    }
                    case 3: {
                        ab.skip(ab.get4());
                        break;
                    }
                    case 48: {
                        ab.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + lmask + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment && level < 64) {
                    bitsRight |= (long)(1 << level);
                }
                lmask = (nodeType & 0xC0) >> 2;
            } else if (lmask <= 3) {
                ab.skip(lmask + 1);
            }
            ++level;
        } while ((lmask & 0x10) == 0);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(bitsRight |= (long)(1 << level));
        }
        return ab.get4f();
    }

    public static <T> T getDecisionPath(double leafAssignment, DecisionPathTracker<T> tr) {
        long l = Double.doubleToRawLongBits(leafAssignment);
        for (int i = 0; i < 64; ++i) {
            boolean right;
            boolean bl = right = (l >> i & 1L) == 1L;
            if (!tr.go(i, right)) break;
        }
        return tr.terminate();
    }

    public static String getDecisionPath(double leafAssignment) {
        return SharedTreeMojoModel.getDecisionPath(leafAssignment, new StringDecisionPathTracker());
    }

    public static int getLeafNodeId(double leafAssignment, byte[] auxTree) {
        LeafDecisionPathTracker tr = new LeafDecisionPathTracker(auxTree);
        return SharedTreeMojoModel.getDecisionPath(leafAssignment, tr).getLeafNodeId();
    }

    private static void computeTreeGraph(SharedTreeSubgraph sg, SharedTreeNode node, byte[] tree, ByteBufferWrapper ab, HashMap<Integer, AuxInfo> auxMap, String[] names, String[][] domains) {
        int nodeType = ab.get1U();
        char colId = ab.get2();
        if (colId == '\uffff') {
            float leafValue = ab.get4f();
            node.setPredValue(leafValue);
            return;
        }
        String colName = names[colId];
        node.setCol(colId, colName);
        int naSplitDir = ab.get1U();
        boolean naVsRest = naSplitDir == NsdNaVsRest;
        boolean leftward = naSplitDir == NsdNaLeft || naSplitDir == NsdLeft;
        node.setLeftward(leftward);
        node.setNaVsRest(naVsRest);
        int lmask = nodeType & 0x33;
        int equal = nodeType & 0xC;
        assert (equal != 4);
        if (!naVsRest) {
            if (equal == 0) {
                float splitVal = ab.get4f();
                node.setSplitValue(splitVal);
            } else {
                GenmodelBitSet bs = new GenmodelBitSet(0);
                if (equal == 8) {
                    bs.fill2(tree, ab);
                } else {
                    bs.fill3(tree, ab);
                }
                node.setBitset(domains[colId], bs);
            }
        }
        AuxInfo auxInfo = auxMap.get(node.getNodeNumber());
        ByteBufferWrapper ab2 = new ByteBufferWrapper(tree);
        ab2.skip(ab.position());
        switch (lmask) {
            case 0: {
                ab2.skip(ab2.get1U());
                break;
            }
            case 1: {
                ab2.skip(ab2.get2());
                break;
            }
            case 2: {
                ab2.skip(ab2.get3());
                break;
            }
            case 3: {
                ab2.skip(ab2.get4());
                break;
            }
            case 48: {
                ab2.skip(4);
                break;
            }
            default: {
                assert (false) : "illegal lmask value " + lmask + " in tree " + Arrays.toString(tree);
                break;
            }
        }
        int lmask2 = (nodeType & 0xC0) >> 2;
        SharedTreeNode newNode = sg.makeRightChildNode(node);
        newNode.setWeight(auxInfo.weightR);
        newNode.setNodeNumber(auxInfo.nidR);
        newNode.setPredValue(auxInfo.predR);
        newNode.setSquaredError(auxInfo.sqErrR);
        if ((lmask2 & 0x10) != 0) {
            float leafValue = ab2.get4f();
            newNode.setPredValue(leafValue);
            auxInfo.predR = leafValue;
        } else {
            SharedTreeMojoModel.computeTreeGraph(sg, newNode, tree, ab2, auxMap, names, domains);
        }
        ab2 = new ByteBufferWrapper(tree);
        ab2.skip(ab.position());
        if (lmask <= 3) {
            ab2.skip(lmask + 1);
        }
        SharedTreeNode newNode2 = sg.makeLeftChildNode(node);
        newNode2.setWeight(auxInfo.weightL);
        newNode2.setNodeNumber(auxInfo.nidL);
        newNode2.setPredValue(auxInfo.predL);
        newNode2.setSquaredError(auxInfo.sqErrL);
        if ((lmask & 0x10) != 0) {
            float leafValue = ab2.get4f();
            newNode2.setPredValue(leafValue);
            auxInfo.predL = leafValue;
        } else {
            SharedTreeMojoModel.computeTreeGraph(sg, newNode2, tree, ab2, auxMap, names, domains);
        }
        if (node.getNodeNumber() == 0) {
            float p = (float)(((double)auxInfo.predL * (double)auxInfo.weightL + (double)auxInfo.predR * (double)auxInfo.weightR) / ((double)auxInfo.weightL + (double)auxInfo.weightR));
            if ((double)Math.abs(p) < 1.0E-7) {
                p = 0.0f;
            }
            node.setPredValue(p);
            node.setSquaredError(auxInfo.sqErrR + auxInfo.sqErrL);
            node.setWeight(auxInfo.weightL + auxInfo.weightR);
        }
        SharedTreeMojoModel.checkConsistency(auxInfo, node);
    }

    public SharedTreeGraph _computeGraph(int treeToPrint) {
        SharedTreeGraph g = new SharedTreeGraph();
        if (treeToPrint >= this._ntree_groups) {
            throw new IllegalArgumentException("Tree " + treeToPrint + " does not exist (max " + this._ntree_groups + ")");
        }
        for (int j = treeToPrint >= 0 ? treeToPrint : 0; j < this._ntree_groups; ++j) {
            for (int i = 0; i < this._ntrees_per_group; ++i) {
                int itree = this.treeIndex(j, i);
                String[] domainValues = this.isSupervised() ? this.getDomainValues(this.getResponseIdx()) : null;
                String treeName = SharedTreeMojoModel.treeName(j, i, domainValues);
                SharedTreeSubgraph sg = g.makeSubgraph(treeName);
                SharedTreeMojoModel.computeTreeGraph(sg, this._compressed_trees[itree], this._compressed_trees_aux[itree], this.getNames(), this.getDomainValues());
            }
            if (treeToPrint >= 0) break;
        }
        return g;
    }

    public static SharedTreeSubgraph computeTreeGraph(int treeNum, String treeName, byte[] tree, byte[] auxTreeInfo, String[] names, String[][] domains) {
        SharedTreeSubgraph sg = new SharedTreeSubgraph(treeNum, treeName);
        SharedTreeMojoModel.computeTreeGraph(sg, tree, auxTreeInfo, names, domains);
        return sg;
    }

    private static void computeTreeGraph(SharedTreeSubgraph sg, byte[] tree, byte[] auxTreeInfo, String[] names, String[][] domains) {
        SharedTreeNode node = sg.makeRootNode();
        node.setSquaredError(Float.NaN);
        node.setPredValue(Float.NaN);
        ByteBufferWrapper ab = new ByteBufferWrapper(tree);
        ByteBufferWrapper abAux = new ByteBufferWrapper(auxTreeInfo);
        HashMap<Integer, AuxInfo> auxMap = SharedTreeMojoModel.readAuxInfos(abAux);
        SharedTreeMojoModel.computeTreeGraph(sg, node, tree, ab, auxMap, names, domains);
    }

    private static HashMap<Integer, AuxInfo> readAuxInfos(ByteBufferWrapper abAux) {
        HashMap<Integer, AuxInfo> auxMap = new HashMap<Integer, AuxInfo>();
        HashMap<Integer, AuxInfo> nodeIdToParent = new HashMap<Integer, AuxInfo>();
        nodeIdToParent.put(0, new AuxInfo());
        boolean reservedFieldIsParentId = false;
        while (abAux.hasRemaining()) {
            AuxInfo parent;
            AuxInfo auxInfo = new AuxInfo(abAux);
            if (auxMap.size() == 0) {
                boolean bl = reservedFieldIsParentId = auxInfo.reserved < 0;
            }
            if ((parent = (AuxInfo)nodeIdToParent.get(auxInfo.nid)) == null) {
                throw new IllegalStateException("Parent for nodeId=" + auxInfo.nid + " not found.");
            }
            assert (!reservedFieldIsParentId || parent.nid == auxInfo.reserved) : "Corrupted Tree Info: parent nodes do not correspond (pid: " + parent.nid + ", reserved: " + AuxInfo.access$900(auxInfo) + ")";
            auxInfo.setPid(parent.nid);
            nodeIdToParent.put(auxInfo.nidL, auxInfo);
            nodeIdToParent.put(auxInfo.nidR, auxInfo);
            auxMap.put(auxInfo.nid, auxInfo);
        }
        return auxMap;
    }

    public static String treeName(int groupIndex, int classIndex, String[] domainValues) {
        String className = "";
        if (domainValues != null) {
            className = ", Class " + domainValues[classIndex];
        }
        return "Tree " + groupIndex + className;
    }

    static void checkConsistency(AuxInfo auxInfo, SharedTreeNode node) {
        boolean ok = true;
        boolean weight_ok = true;
        ok &= auxInfo.nid == node.getNodeNumber();
        double sum = 0.0;
        if (node.leftChild != null) {
            ok &= auxInfo.nidL == node.leftChild.getNodeNumber();
            ok &= auxInfo.weightL == node.leftChild.getWeight();
            ok &= auxInfo.predL == node.leftChild.predValue;
            ok &= auxInfo.sqErrL == node.leftChild.squaredError;
            sum += (double)node.leftChild.getWeight();
        }
        if (node.rightChild != null) {
            ok &= auxInfo.nidR == node.rightChild.getNodeNumber();
            ok &= auxInfo.weightR == node.rightChild.getWeight();
            ok &= auxInfo.predR == node.rightChild.predValue;
            ok &= auxInfo.sqErrR == node.rightChild.squaredError;
            sum += (double)node.rightChild.getWeight();
        }
        if (node.parent != null) {
            ok &= auxInfo.pid == node.parent.getNodeNumber();
            weight_ok = Math.abs((double)node.getWeight() - sum) < 1.0E-5 * ((double)node.getWeight() + sum);
            ok &= weight_ok;
        }
        if (!ok) {
            System.err.println("\nTree inconsistency found:");
            if (node.depth == 1 && !weight_ok) {
                System.err.println("Note: this is a known issue for DRF and Isolation Forest models, please refer to https://0xdata.atlassian.net/browse/PUBDEV-6140");
            }
            node.print(System.err, "parent");
            node.leftChild.print(System.err, "left child");
            node.rightChild.print(System.err, "right child");
            System.err.println("Auxiliary tree info:");
            System.err.println(auxInfo.toString());
        }
    }

    protected SharedTreeMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    protected void scoreAllTrees(double[] row, double[] preds) {
        Arrays.fill(preds, 0.0);
        this.scoreTreeRange(row, 0, this._ntree_groups, preds);
    }

    public abstract double[] unifyPreds(double[] var1, double var2, double[] var4);

    public final void scoreSingleTree(double[] row, int index, double[] preds) {
        this.scoreTreeRange(row, index, index + 1, preds);
    }

    public final void scoreTreeRange(double[] row, int fromIndex, int toIndex, double[] preds) {
        int clOffset = this._nclasses == 1 ? 0 : 1;
        for (int classIndex = 0; classIndex < this._ntrees_per_group; ++classIndex) {
            int k = clOffset + classIndex;
            int itree = this.treeIndex(fromIndex, classIndex);
            for (int groupIndex = fromIndex; groupIndex < toIndex; ++groupIndex) {
                if (this._compressed_trees[itree] != null) {
                    int n = k;
                    preds[n] = preds[n] + this._scoreTree.scoreTree(this._compressed_trees[itree], row, false, this._domains);
                }
                ++itree;
            }
        }
    }

    public String[] getDecisionPathNames() {
        int classTrees = 0;
        for (int i = 0; i < this._ntrees_per_group; ++i) {
            int itree = this.treeIndex(0, i);
            if (this._compressed_trees[itree] == null) continue;
            ++classTrees;
        }
        int outputcols = this._ntree_groups * classTrees;
        String[] names = new String[outputcols];
        for (int c = 0; c < this._ntrees_per_group; ++c) {
            for (int tidx = 0; tidx < this._ntree_groups; ++tidx) {
                int itree = this.treeIndex(tidx, c);
                if (this._compressed_trees[itree] == null) continue;
                names[itree] = "T" + (tidx + 1) + ".C" + (c + 1);
            }
        }
        return names;
    }

    public LeafNodeAssignments getLeafNodeAssignments(double[] row) {
        LeafNodeAssignments assignments = new LeafNodeAssignments();
        assignments._paths = new String[this._compressed_trees.length];
        if (this._mojo_version >= 1.3 && this._compressed_trees_aux != null) {
            assignments._nodeIds = new int[this._compressed_trees_aux.length];
        }
        this.traceDecisions(row, assignments._paths, assignments._nodeIds);
        return assignments;
    }

    public String[] getDecisionPath(double[] row) {
        String[] paths = new String[this._compressed_trees.length];
        this.traceDecisions(row, paths, null);
        return paths;
    }

    private void traceDecisions(double[] row, String[] paths, int[] nodeIds) {
        if (this._mojo_version < 1.2) {
            throw new IllegalArgumentException("You can only obtain decision tree path with mojo versions 1.2 or higher");
        }
        for (int j = 0; j < this._ntree_groups; ++j) {
            for (int i = 0; i < this._ntrees_per_group; ++i) {
                int itree = this.treeIndex(j, i);
                double d = SharedTreeMojoModel.scoreTree(this._compressed_trees[itree], row, true, this._domains);
                if (paths != null) {
                    paths[itree] = SharedTreeMojoModel.getDecisionPath(d);
                }
                if (nodeIds == null) continue;
                assert (this._mojo_version >= 1.3);
                nodeIds[itree] = SharedTreeMojoModel.getLeafNodeId(d, this._compressed_trees_aux[itree]);
            }
        }
    }

    final int treeIndex(int groupIndex, int classIndex) {
        return classIndex * this._ntree_groups + groupIndex;
    }

    public static double scoreTree0(byte[] tree, double[] row, boolean computeLeafAssignment) {
        int lmask;
        ByteBufferWrapper ab = new ByteBufferWrapper(tree);
        GenmodelBitSet bs = null;
        long bitsRight = 0L;
        int level = 0;
        do {
            double d;
            int nodeType = ab.get1U();
            char colId = ab.get2();
            if (colId == '\uffff') {
                return ab.get4f();
            }
            int naSplitDir = ab.get1U();
            boolean naVsRest = naSplitDir == NsdNaVsRest;
            boolean leftward = naSplitDir == NsdNaLeft || naSplitDir == NsdLeft;
            lmask = nodeType & 0x33;
            int equal = nodeType & 0xC;
            assert (equal != 4);
            float splitVal = -1.0f;
            if (!naVsRest) {
                if (equal == 0) {
                    splitVal = ab.get4f();
                } else {
                    if (bs == null) {
                        bs = new GenmodelBitSet(0);
                    }
                    if (equal == 8) {
                        bs.fill2(tree, ab);
                    } else {
                        bs.fill3_1(tree, ab);
                    }
                }
            }
            if (Double.isNaN(d = row[colId]) ? !leftward : !naVsRest && (equal == 0 ? d >= (double)splitVal : bs.contains0((int)d))) {
                switch (lmask) {
                    case 0: {
                        ab.skip(ab.get1U());
                        break;
                    }
                    case 1: {
                        ab.skip(ab.get2());
                        break;
                    }
                    case 2: {
                        ab.skip(ab.get3());
                        break;
                    }
                    case 3: {
                        ab.skip(ab.get4());
                        break;
                    }
                    case 48: {
                        ab.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + lmask + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment && level < 64) {
                    bitsRight |= (long)(1 << level);
                }
                lmask = (nodeType & 0xC0) >> 2;
            } else if (lmask <= 3) {
                ab.skip(lmask + 1);
            }
            ++level;
        } while ((lmask & 0x10) == 0);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(bitsRight |= (long)(1 << level));
        }
        return ab.get4f();
    }

    public static double scoreTree1(byte[] tree, double[] row, boolean computeLeafAssignment) {
        int lmask;
        ByteBufferWrapper ab = new ByteBufferWrapper(tree);
        GenmodelBitSet bs = null;
        long bitsRight = 0L;
        int level = 0;
        do {
            double d;
            int nodeType = ab.get1U();
            char colId = ab.get2();
            if (colId == '\uffff') {
                return ab.get4f();
            }
            int naSplitDir = ab.get1U();
            boolean naVsRest = naSplitDir == NsdNaVsRest;
            boolean leftward = naSplitDir == NsdNaLeft || naSplitDir == NsdLeft;
            lmask = nodeType & 0x33;
            int equal = nodeType & 0xC;
            assert (equal != 4);
            float splitVal = -1.0f;
            if (!naVsRest) {
                if (equal == 0) {
                    splitVal = ab.get4f();
                } else {
                    if (bs == null) {
                        bs = new GenmodelBitSet(0);
                    }
                    if (equal == 8) {
                        bs.fill2(tree, ab);
                    } else {
                        bs.fill3_1(tree, ab);
                    }
                }
            }
            if (Double.isNaN(d = row[colId]) || equal != 0 && bs != null && !bs.isInRange((int)d) ? !leftward : !naVsRest && (equal == 0 ? d >= (double)splitVal : bs.contains((int)d))) {
                switch (lmask) {
                    case 0: {
                        ab.skip(ab.get1U());
                        break;
                    }
                    case 1: {
                        ab.skip(ab.get2());
                        break;
                    }
                    case 2: {
                        ab.skip(ab.get3());
                        break;
                    }
                    case 3: {
                        ab.skip(ab.get4());
                        break;
                    }
                    case 48: {
                        ab.skip(4);
                        break;
                    }
                    default: {
                        assert (false) : "illegal lmask value " + lmask + " in tree " + Arrays.toString(tree);
                        break;
                    }
                }
                if (computeLeafAssignment && level < 64) {
                    bitsRight |= (long)(1 << level);
                }
                lmask = (nodeType & 0xC0) >> 2;
            } else if (lmask <= 3) {
                ab.skip(lmask + 1);
            }
            ++level;
        } while ((lmask & 0x10) == 0);
        if (computeLeafAssignment) {
            return Double.longBitsToDouble(bitsRight |= (long)(1 << level));
        }
        return ab.get4f();
    }

    @Override
    public boolean calibrateClassProbabilities(double[] preds) {
        if (this._calib_glm_beta == null) {
            return false;
        }
        assert (this._nclasses == 2);
        assert (preds.length == this._nclasses + 1);
        double p = SharedTreeMojoModel.GLM_logitInv(preds[1] * this._calib_glm_beta[0] + this._calib_glm_beta[1]);
        preds[1] = 1.0 - p;
        preds[2] = p;
        return true;
    }

    @Override
    public SharedTreeGraph convert(int treeNumber, String treeClass) {
        return this._computeGraph(treeNumber);
    }

    public double[] scoreStagedPredictions(double[] row, int predsLength) {
        int contribOffset = this.nclasses() == 1 ? 0 : 1;
        double[] trees_result = new double[this._ntree_groups * this._ntrees_per_group];
        for (int groupIndex = 0; groupIndex < this._ntree_groups; ++groupIndex) {
            double[] tmpPreds = new double[predsLength];
            this.scoreTreeRange(row, 0, groupIndex + 1, tmpPreds);
            this.unifyPreds(row, 0.0, tmpPreds);
            for (int classIndex = 0; classIndex < this._ntrees_per_group; ++classIndex) {
                int tree_index = groupIndex * this._ntrees_per_group + classIndex;
                trees_result[tree_index] = tmpPreds[contribOffset + classIndex];
            }
        }
        return trees_result;
    }

    public static class LeafNodeAssignments {
        public String[] _paths;
        public int[] _nodeIds;
    }

    static class AuxInfo {
        private static int SIZE = 40;
        public int nid;
        public int pid;
        public int nidL;
        public int nidR;
        private final int reserved;
        public float weightL;
        public float weightR;
        public float predL;
        public float predR;
        public float sqErrL;
        public float sqErrR;

        private AuxInfo() {
            this.nid = -1;
            this.reserved = -1;
        }

        AuxInfo(ByteBufferWrapper abAux) {
            this.nid = abAux.get4();
            this.reserved = abAux.get4();
            this.weightL = abAux.get4f();
            this.weightR = abAux.get4f();
            this.predL = abAux.get4f();
            this.predR = abAux.get4f();
            this.sqErrL = abAux.get4f();
            this.sqErrR = abAux.get4f();
            this.nidL = abAux.get4();
            this.nidR = abAux.get4();
        }

        final void setPid(int parentId) {
            this.pid = parentId;
        }

        public String toString() {
            return "nid: " + this.nid + "\npid: " + this.pid + "\nnidL: " + this.nidL + "\nnidR: " + this.nidR + "\nweightL: " + this.weightL + "\nweightR: " + this.weightR + "\npredL: " + this.predL + "\npredR: " + this.predR + "\nsqErrL: " + this.sqErrL + "\nsqErrR: " + this.sqErrR + "\nreserved: " + this.reserved + "\n";
        }
    }

    private static class AuxInfoLightReader {
        private final ByteBufferWrapper _abAux;
        int _nid;
        int _numLeftChildren;

        private AuxInfoLightReader(ByteBufferWrapper abAux) {
            this._abAux = abAux;
        }

        private void readNext() {
            this._nid = this._abAux.get4();
            this._numLeftChildren = this._abAux.get4();
        }

        private boolean hasNext() {
            return this._abAux.hasRemaining();
        }

        private int getLeftNodeIdAndSkipNode() {
            this._abAux.skip(24);
            int n = this._abAux.get4();
            this._abAux.skip(4);
            return n;
        }

        private int getRightNodeIdAndSkipNode() {
            this._abAux.skip(28);
            return this._abAux.get4();
        }

        private void skipNode() {
            this._abAux.skip(AuxInfo.SIZE - 8);
        }

        private void skipNodes(int num) {
            this._abAux.skip(AuxInfo.SIZE * num);
        }
    }

    public static class LeafDecisionPathTracker
    implements DecisionPathTracker<LeafDecisionPathTracker> {
        private final AuxInfoLightReader _auxInfo;
        private boolean _wentRight = false;
        private int _nodeId = 0;

        private LeafDecisionPathTracker(byte[] auxTree) {
            this._auxInfo = new AuxInfoLightReader(new ByteBufferWrapper(auxTree));
        }

        @Override
        public boolean go(int depth, boolean right) {
            if (!this._auxInfo.hasNext()) {
                assert (this._wentRight || depth == 0);
                return false;
            }
            this._auxInfo.readNext();
            if (right) {
                if (this._wentRight && this._nodeId != this._auxInfo._nid) {
                    return false;
                }
                this._nodeId = this._auxInfo.getRightNodeIdAndSkipNode();
                this._auxInfo.skipNodes(this._auxInfo._numLeftChildren);
                this._wentRight = true;
            } else {
                this._wentRight = false;
                if (this._auxInfo._numLeftChildren == 0) {
                    this._nodeId = this._auxInfo.getLeftNodeIdAndSkipNode();
                    return false;
                }
                this._auxInfo.skipNode();
            }
            return true;
        }

        @Override
        public LeafDecisionPathTracker terminate() {
            return this;
        }

        final int getLeafNodeId() {
            return this._nodeId;
        }
    }

    public static class StringDecisionPathTracker
    implements DecisionPathTracker<String> {
        private final char[] _sb = new char[64];
        private int _pos = 0;

        @Override
        public boolean go(int depth, boolean right) {
            int n = this._sb[depth] = right ? 82 : 76;
            if (right) {
                this._pos = depth;
            }
            return true;
        }

        @Override
        public String terminate() {
            String path = new String(this._sb, 0, this._pos);
            this._pos = 0;
            return path;
        }
    }

    public static interface DecisionPathTracker<T> {
        public boolean go(int var1, boolean var2);

        public T terminate();
    }
}

