/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.descriptor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.descriptor.Table;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.regex.Pattern;

public class JsonModelDescriptorReader {
    public static final String MODEL_DETAILS_FILE = "experimental/modelDetails.json";
    private static final Pattern JSON_PATH_PATTERN = Pattern.compile("\\.|\\[|\\]");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject parseModelJson(MojoReaderBackend mojoReaderBackend) {
        try (BufferedReader fileReader = mojoReaderBackend.getTextFile(MODEL_DETAILS_FILE);){
            Gson gson = new GsonBuilder().create();
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read file inside MOJO experimental/modelDetails.json", e);
        }
    }

    public static Table extractTableFromJson(JsonObject modelJson, String tablePath) {
        Objects.requireNonNull(modelJson);
        JsonElement potentialTableJson = JsonModelDescriptorReader.findInJson((JsonElement)modelJson, tablePath);
        if (potentialTableJson.isJsonNull()) {
            System.out.println(String.format("Failed to extract element '%s' MojoModel dump.", tablePath));
            return null;
        }
        JsonObject tableJson = potentialTableJson.getAsJsonObject();
        int rowCount = tableJson.get("rowcount").getAsInt();
        JsonArray columns = JsonModelDescriptorReader.findInJson((JsonElement)tableJson, "columns").getAsJsonArray();
        int columnCount = columns.size();
        String[] columnHeaders = new String[columnCount];
        Table.ColumnType[] columnTypes = new Table.ColumnType[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonObject column = columns.get(i).getAsJsonObject();
            columnHeaders[i] = column.get("description").getAsString();
            columnTypes[i] = Table.ColumnType.extractType(column.get("type").getAsString());
        }
        JsonArray dataColumns = JsonModelDescriptorReader.findInJson((JsonElement)tableJson, "data").getAsJsonArray();
        Object[][] data = new Object[columnCount][rowCount];
        for (int i = 0; i < columnCount; ++i) {
            JsonArray column = dataColumns.get(i).getAsJsonArray();
            block7: for (int j = 0; j < rowCount; ++j) {
                JsonPrimitive primitiveValue = column.get(j).getAsJsonPrimitive();
                switch (columnTypes[i]) {
                    case LONG: {
                        data[i][j] = primitiveValue.getAsLong();
                        continue block7;
                    }
                    case DOUBLE: {
                        data[i][j] = primitiveValue.getAsDouble();
                        continue block7;
                    }
                    case STRING: {
                        data[i][j] = primitiveValue.getAsString();
                    }
                }
            }
        }
        return new Table(tableJson.get("name").getAsString(), tableJson.get("description").getAsString(), new String[rowCount], columnHeaders, columnTypes, "", data);
    }

    private static JsonElement findInJson(JsonElement jsonElement, String jsonPath) {
        String[] route = JSON_PATH_PATTERN.split(jsonPath);
        JsonElement result = jsonElement;
        for (String key : route) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) {
                result = JsonNull.INSTANCE;
                break;
            }
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            int value = Integer.valueOf(key) - 1;
            result = ((JsonArray)result).get(value);
        }
        return result;
    }
}

