/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.descriptor;

import hex.ModelCategory;
import hex.genmodel.ModelDescriptor;
import hex.genmodel.MojoModel;
import hex.genmodel.descriptor.Table;
import hex.genmodel.descriptor.VariableImportances;
import java.util.Arrays;

public class ModelDescriptorBuilder {
    private final String _h2oVersion;
    private final ModelCategory _category;
    private final String _uuid;
    private final boolean _supervised;
    private final int _nfeatures;
    private final int _nclasses;
    private final boolean _balanceClasses;
    private final double _defaultThreshold;
    private final double[] _priorClassDistrib;
    private final double[] _modelClassDistrib;
    private final String _offsetColumn;
    private final String[][] _domains;
    private final String[] _names;
    private final String _algoName;
    private VariableImportances _variableImportances = null;
    private Table _modelSummary = null;

    public ModelDescriptorBuilder(MojoModel mojoModel) {
        this._category = mojoModel._category;
        this._uuid = mojoModel._uuid;
        this._supervised = mojoModel.isSupervised();
        this._nfeatures = mojoModel.nfeatures();
        this._nclasses = mojoModel._nclasses;
        this._balanceClasses = mojoModel._balanceClasses;
        this._defaultThreshold = mojoModel._defaultThreshold;
        this._priorClassDistrib = mojoModel._priorClassDistrib;
        this._modelClassDistrib = mojoModel._modelClassDistrib;
        this._h2oVersion = mojoModel._h2oVersion;
        this._offsetColumn = mojoModel._offsetColumn;
        this._domains = mojoModel._domains;
        this._names = mojoModel._names;
        this._algoName = mojoModel.getClass().getName();
    }

    public ModelDescriptorBuilder variableImportances(VariableImportances variableImportances) {
        this._variableImportances = variableImportances;
        return this;
    }

    public ModelDescriptorBuilder modelSummary(Table modelSummary) {
        this._modelSummary = modelSummary;
        return this;
    }

    public ModelDescriptor build() {
        return new ModelDescriptor(){

            @Override
            public String[][] scoringDomains() {
                return ModelDescriptorBuilder.this._domains;
            }

            @Override
            public String projectVersion() {
                return ModelDescriptorBuilder.this._h2oVersion;
            }

            @Override
            public String algoName() {
                return ModelDescriptorBuilder.this._algoName;
            }

            @Override
            public String algoFullName() {
                return ModelDescriptorBuilder.this._algoName;
            }

            @Override
            public String offsetColumn() {
                return ModelDescriptorBuilder.this._offsetColumn;
            }

            @Override
            public String weightsColumn() {
                return null;
            }

            @Override
            public String foldColumn() {
                return null;
            }

            @Override
            public ModelCategory getModelCategory() {
                return ModelDescriptorBuilder.this._category;
            }

            @Override
            public boolean isSupervised() {
                return ModelDescriptorBuilder.this._supervised;
            }

            @Override
            public int nfeatures() {
                return ModelDescriptorBuilder.this._nfeatures;
            }

            @Override
            public String[] features() {
                return Arrays.copyOf(this.columnNames(), this.nfeatures());
            }

            @Override
            public int nclasses() {
                return ModelDescriptorBuilder.this._nclasses;
            }

            @Override
            public String[] columnNames() {
                return ModelDescriptorBuilder.this._names;
            }

            @Override
            public boolean balanceClasses() {
                return ModelDescriptorBuilder.this._balanceClasses;
            }

            @Override
            public double defaultThreshold() {
                return ModelDescriptorBuilder.this._defaultThreshold;
            }

            @Override
            public double[] priorClassDist() {
                return ModelDescriptorBuilder.this._priorClassDistrib;
            }

            @Override
            public double[] modelClassDist() {
                return ModelDescriptorBuilder.this._modelClassDistrib;
            }

            @Override
            public String uuid() {
                return ModelDescriptorBuilder.this._uuid;
            }

            @Override
            public String timestamp() {
                return null;
            }

            @Override
            public VariableImportances variableImportances() {
                return ModelDescriptorBuilder.this._variableImportances;
            }

            @Override
            public Table modelSummary() {
                return ModelDescriptorBuilder.this._modelSummary;
            }
        };
    }
}

