/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gbm;

import ai.h2o.algos.tree.INode;
import ai.h2o.algos.tree.INodeStat;
import hex.genmodel.GenModel;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeGraphConverter;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeSHAP;
import hex.genmodel.algos.tree.TreeSHAPEnsemble;
import hex.genmodel.algos.tree.TreeSHAPPredictor;
import hex.genmodel.utils.DistributionFamily;
import java.util.ArrayList;

public final class GbmMojoModel
extends SharedTreeMojoModel
implements SharedTreeGraphConverter,
PredictContributionsFactory {
    public DistributionFamily _family;
    public double _init_f;

    public GbmMojoModel(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public final double[] score0(double[] row, double offset, double[] preds) {
        super.scoreAllTrees(row, preds);
        return this.unifyPreds(row, offset, preds);
    }

    @Override
    public final double[] unifyPreds(double[] row, double offset, double[] preds) {
        if (this._family == DistributionFamily.bernoulli || this._family == DistributionFamily.quasibinomial || this._family == DistributionFamily.modified_huber) {
            double f = preds[1] + this._init_f + offset;
            preds[2] = this._family.linkInv(f);
            preds[1] = 1.0 - preds[2];
        } else if (this._family == DistributionFamily.multinomial) {
            if (this._nclasses == 2) {
                preds[1] = preds[1] + (this._init_f + offset);
                preds[2] = -preds[1];
            }
            GenModel.GBM_rescale(preds);
        } else {
            double f = preds[0] + this._init_f + offset;
            preds[0] = this._family.linkInv(f);
            return preds;
        }
        if (this._balanceClasses) {
            GenModel.correctProbabilities(preds, this._priorClassDistrib, this._modelClassDistrib);
        }
        preds[0] = GenModel.getPrediction(preds, this._priorClassDistrib, row, this._defaultThreshold);
        return preds;
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        return this.score0(row, 0.0, preds);
    }

    public String[] leaf_node_assignment(double[] row) {
        return this.getDecisionPath(row);
    }

    @Override
    public PredictContributions makeContributionsPredictor() {
        if (this._nclasses > 2) {
            throw new UnsupportedOperationException("Predicting contributions for multinomial classification problems is not yet supported.");
        }
        SharedTreeGraph graph = this._computeGraph(-1);
        SharedTreeNode[] empty = new SharedTreeNode[]{};
        ArrayList treeSHAPs = new ArrayList(graph.subgraphArray.size());
        for (SharedTreeSubgraph tree : graph.subgraphArray) {
            INode[] nodes = tree.nodesArray.toArray(empty);
            treeSHAPs.add(new TreeSHAP(nodes, (INodeStat[])nodes, 0));
        }
        TreeSHAPEnsemble predictor = new TreeSHAPEnsemble(treeSHAPs, (float)this._init_f);
        return new GbmContributionsPredictor(predictor);
    }

    private final class GbmContributionsPredictor
    implements PredictContributions {
        private final TreeSHAPPredictor<double[]> _treeSHAPPredictor;
        private final Object _workspace;

        private GbmContributionsPredictor(TreeSHAPPredictor<double[]> treeSHAPPredictor) {
            this._treeSHAPPredictor = treeSHAPPredictor;
            this._workspace = this._treeSHAPPredictor.makeWorkspace();
        }

        @Override
        public float[] calculateContributions(double[] input) {
            float[] contribs = new float[GbmMojoModel.this.nfeatures() + 1];
            return this._treeSHAPPredictor.calculateContributions(input, contribs, 0, -1, this._workspace);
        }
    }
}

