/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import ai.h2o.algos.tree.INode;
import ai.h2o.algos.tree.INodeStat;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeSHAP;
import hex.genmodel.algos.tree.TreeSHAPEnsemble;
import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.ArrayList;

public abstract class SharedTreeMojoModelWithContributions
extends SharedTreeMojoModel
implements PredictContributionsFactory {
    protected SharedTreeMojoModelWithContributions(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public PredictContributions makeContributionsPredictor() {
        if (this._nclasses > 2) {
            throw new UnsupportedOperationException("Predicting contributions for multinomial classification problems is not yet supported.");
        }
        SharedTreeGraph graph = this._computeGraph(-1);
        SharedTreeNode[] empty = new SharedTreeNode[]{};
        ArrayList treeSHAPs = new ArrayList(graph.subgraphArray.size());
        for (SharedTreeSubgraph tree : graph.subgraphArray) {
            INode[] nodes = tree.nodesArray.toArray(empty);
            treeSHAPs.add(new TreeSHAP(nodes, (INodeStat[])nodes, 0));
        }
        TreeSHAPEnsemble<double[]> predictor = new TreeSHAPEnsemble<double[]>(treeSHAPs, (float)this.getInitF());
        return this.getContributionsPredictor(predictor);
    }

    public double getInitF() {
        return 0.0;
    }

    protected abstract ContributionsPredictor getContributionsPredictor(TreeSHAPPredictor<double[]> var1);

    public class ContributionsPredictor
    implements PredictContributions {
        private final TreeSHAPPredictor<double[]> _treeSHAPPredictor;
        private final Object _workspace;

        public ContributionsPredictor(TreeSHAPPredictor<double[]> treeSHAPPredictor) {
            this._treeSHAPPredictor = treeSHAPPredictor;
            this._workspace = this._treeSHAPPredictor.makeWorkspace();
        }

        @Override
        public float[] calculateContributions(double[] input) {
            float[] contribs = new float[SharedTreeMojoModelWithContributions.this.nfeatures() + 1];
            this._treeSHAPPredictor.calculateContributions(input, contribs, 0, -1, this._workspace);
            return this.getContribs(contribs);
        }

        public float[] getContribs(float[] contribs) {
            return contribs;
        }
    }
}

