/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.Collection;

public class TreeSHAPEnsemble<R>
implements TreeSHAPPredictor<R> {
    private final TreeSHAPPredictor<R>[] _predictors;
    private final float _initPred;

    public TreeSHAPEnsemble(Collection<TreeSHAPPredictor<R>> predictors, float initPred) {
        this._predictors = predictors.toArray(new TreeSHAPPredictor[0]);
        this._initPred = initPred;
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs) {
        return this.calculateContributions(feat, out_contribs, 0, -1, this.makeWorkspace());
    }

    @Override
    public float[] calculateContributions(R feat, float[] out_contribs, int condition, int condition_feature, Object workspace) {
        Object[] workspaces = (Object[])workspace;
        if (condition == 0) {
            int n = out_contribs.length - 1;
            out_contribs[n] = out_contribs[n] + this._initPred;
        }
        for (int i = 0; i < this._predictors.length; ++i) {
            this._predictors[i].calculateContributions(feat, out_contribs, condition, condition_feature, workspaces[i]);
        }
        return out_contribs;
    }

    @Override
    public Object makeWorkspace() {
        Object[] workspaces = new Object[this._predictors.length];
        for (int i = 0; i < workspaces.length; ++i) {
            workspaces[i] = this._predictors[i].makeWorkspace();
        }
        return workspaces;
    }
}

