/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.deeplearning.DeeplearningMojoReader;
import hex.genmodel.algos.deepwater.DeepwaterMojoReader;
import hex.genmodel.algos.drf.DrfMojoReader;
import hex.genmodel.algos.ensemble.StackedEnsembleMojoReader;
import hex.genmodel.algos.gbm.GbmMojoReader;
import hex.genmodel.algos.glm.GlmMojoReader;
import hex.genmodel.algos.glrm.GlrmMojoReader;
import hex.genmodel.algos.isofor.IsolationForestMojoReader;
import hex.genmodel.algos.kmeans.KMeansMojoReader;
import hex.genmodel.algos.pipeline.MojoPipelineReader;
import hex.genmodel.algos.svm.SvmMojoReader;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoReader;
import hex.genmodel.algos.word2vec.Word2VecMojoReader;
import java.util.ServiceLoader;

public class ModelMojoFactory {
    public static final ModelMojoFactory INSTANCE = new ModelMojoFactory();
    private final ServiceLoader<ModelMojoReader> loader = ServiceLoader.load(ModelMojoReader.class);

    private ModelMojoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelMojoReader loadMojoReader(String algo) {
        assert (algo != null) : "Name of algorithm should be != null!";
        ServiceLoader<ModelMojoReader> serviceLoader = this.loader;
        synchronized (serviceLoader) {
            this.loader.reload();
            for (ModelMojoReader mrb : this.loader) {
                if (!algo.equals(mrb.getModelName())) continue;
                return mrb;
            }
        }
        return null;
    }

    public ModelMojoReader getMojoReader(String algo) {
        if (algo == null) {
            throw new IllegalArgumentException("Algorithm not specified.");
        }
        switch (algo) {
            case "Distributed Random Forest": {
                return new DrfMojoReader();
            }
            case "Gradient Boosting Method": 
            case "Gradient Boosting Machine": {
                return new GbmMojoReader();
            }
            case "Deep Water": {
                return new DeepwaterMojoReader();
            }
            case "Generalized Low Rank Modeling": 
            case "Generalized Low Rank Model": {
                return new GlrmMojoReader();
            }
            case "Generalized Linear Modeling": 
            case "Generalized Linear Model": {
                return new GlmMojoReader();
            }
            case "Word2Vec": {
                return new Word2VecMojoReader();
            }
            case "TargetEncoder": {
                return new TargetEncoderMojoReader();
            }
            case "Isolation Forest": {
                return new IsolationForestMojoReader();
            }
            case "K-means": {
                return new KMeansMojoReader();
            }
            case "Deep Learning": 
            case "deep learning": {
                return new DeeplearningMojoReader();
            }
            case "Support Vector Machine (*Spark*)": {
                return new SvmMojoReader();
            }
            case "StackedEnsemble": 
            case "Stacked Ensemble": {
                return new StackedEnsembleMojoReader();
            }
            case "MOJO Pipeline": {
                return new MojoPipelineReader();
            }
        }
        ModelMojoReader mmr = this.loadMojoReader(algo);
        if (mmr != null) {
            return mmr;
        }
        throw new IllegalStateException("Algorithm `" + algo + "` is not supported by this version of h2o-genmodel. If you are using an algorithm implemented in an extension, be sure to include a jar dependency of the extension (eg.: ai.h2o:h2o-genmodel-ext-" + algo.toLowerCase() + ")");
    }
}

