/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.targetencoder;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TargetEncoderMojoReader
extends ModelMojoReader<TargetEncoderMojoModel> {
    private static final String ENCODING_MAP_PATH = "feature_engineering/target_encoding/encoding_map.ini";
    private static final String COLUMN_MAP_PATH = "feature_engineering/target_encoding/te_column_name_to_idx_map.ini";
    private static final String MISSING_VALUES_PRESENCE_MAP_PATH = "feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini";

    @Override
    public String getModelName() {
        return "TargetEncoder";
    }

    @Override
    protected void readModelData() throws IOException {
        ((TargetEncoderMojoModel)this._model)._withBlending = (Boolean)this.readkv("with_blending");
        if (((TargetEncoderMojoModel)this._model)._withBlending) {
            ((TargetEncoderMojoModel)this._model)._inflectionPoint = (Double)this.readkv("inflection_point");
            ((TargetEncoderMojoModel)this._model)._smoothing = (Double)this.readkv("smoothing");
        }
        ((TargetEncoderMojoModel)this._model)._targetEncodingMap = this.parseEncodingMap();
        ((TargetEncoderMojoModel)this._model)._teColumnNameToIdx = this.parseTEColumnNameToIndexMap();
        ((TargetEncoderMojoModel)this._model)._teColumnNameToMissingValuesPresence = this.parseTEColumnNameToMissingValuesPresenceMap();
        ((TargetEncoderMojoModel)this._model)._priorMean = (Double)this.readkv("priorMean");
    }

    @Override
    protected TargetEncoderMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new TargetEncoderMojoModel(columns, domains, responseColumn);
    }

    private Map<String, Integer> parseTEColumnNameToIndexMap() throws IOException {
        HashMap<String, Integer> teColumnNameToIndexMap = new HashMap<String, Integer>();
        if (this.exists(COLUMN_MAP_PATH)) {
            Iterable<String> parsedFile = this.readtext(COLUMN_MAP_PATH);
            for (String line : parsedFile) {
                String[] nameAndIndex = line.split("\\s*=\\s*", 2);
                teColumnNameToIndexMap.put(nameAndIndex[0], Integer.parseInt(nameAndIndex[1]));
            }
        }
        return teColumnNameToIndexMap;
    }

    private Map<String, Integer> parseTEColumnNameToMissingValuesPresenceMap() throws IOException {
        HashMap<String, Integer> teColumnNameToMissingValuesPresenceMap = new HashMap<String, Integer>();
        if (this.exists(MISSING_VALUES_PRESENCE_MAP_PATH)) {
            Iterable<String> parsedFile = this.readtext(MISSING_VALUES_PRESENCE_MAP_PATH);
            for (String line : parsedFile) {
                String[] indexAndPresence = line.split("\\s*=\\s*", 2);
                teColumnNameToMissingValuesPresenceMap.put(indexAndPresence[0], Integer.parseInt(indexAndPresence[1]));
            }
        }
        return teColumnNameToMissingValuesPresenceMap;
    }

    public EncodingMaps parseEncodingMap() throws IOException {
        HashMap<String, EncodingMap> encodingMaps;
        if (!this.exists(ENCODING_MAP_PATH)) {
            return null;
        }
        try (BufferedReader source = this.getMojoReaderBackend().getTextFile(ENCODING_MAP_PATH);){
            encodingMaps = new HashMap<String, EncodingMap>();
            HashMap<Integer, Object> encodingsForColumn = null;
            String sectionName = null;
            while (true) {
                String line;
                if ((line = source.readLine()) == null) {
                    encodingMaps.put(sectionName, new EncodingMap(encodingsForColumn));
                    break;
                }
                line = line.trim();
                if (sectionName == null) {
                    sectionName = this.matchNewSection(line);
                    encodingsForColumn = new HashMap<Integer, int[]>();
                    continue;
                }
                String matchResult = this.matchNewSection(line);
                if (matchResult != null) {
                    encodingMaps.put(sectionName, new EncodingMap(encodingsForColumn));
                    encodingsForColumn = new HashMap();
                    sectionName = matchResult;
                    continue;
                }
                String[] res = line.split("\\s*=\\s*", 2);
                int[] numAndDenom = this.processNumeratorAndDenominator(res[1].split(" "));
                encodingsForColumn.put(Integer.parseInt(res[0]), numAndDenom);
            }
        }
        return new EncodingMaps(encodingMaps);
    }

    private String matchNewSection(String line) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private int[] processNumeratorAndDenominator(String[] strings) {
        int[] intArray = new int[strings.length];
        int i = 0;
        for (String str : strings) {
            intArray[i] = Integer.parseInt(str);
            ++i;
        }
        return intArray;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

