/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.easy;

import hex.genmodel.GenModel;
import hex.genmodel.algos.deepwater.DeepwaterMojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.exception.PredictNumberFormatException;
import hex.genmodel.easy.exception.PredictUnknownCategoricalLevelException;
import hex.genmodel.easy.exception.PredictUnknownTypeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class RowToRawDataConverter {
    public final GenModel _m;
    private final HashMap<String, Integer> _modelColumnNameToIndexMap;
    private final HashMap<Integer, HashMap<String, Integer>> _domainMap;
    private final EasyPredictModelWrapper.ErrorConsumer _errorConsumer;
    private final boolean _convertUnknownCategoricalLevelsToNa;
    private final boolean _convertInvalidNumbersToNa;

    public RowToRawDataConverter(GenModel m, HashMap<String, Integer> modelColumnNameToIndexMap, HashMap<Integer, HashMap<String, Integer>> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, boolean convertUnknownCategoricalLevelsToNa, boolean convertInvalidNumbersToNa) {
        this._m = m;
        this._modelColumnNameToIndexMap = modelColumnNameToIndexMap;
        this._domainMap = domainMap;
        this._errorConsumer = errorConsumer;
        this._convertUnknownCategoricalLevelsToNa = convertUnknownCategoricalLevelsToNa;
        this._convertInvalidNumbersToNa = convertInvalidNumbersToNa;
    }

    /*
     * Unable to fully structure code
     */
    public double[] convert(RowData data, double[] rawData) throws PredictException {
        isImage = this._m instanceof DeepwaterMojoModel != false && ((DeepwaterMojoModel)this._m)._problem_type.equals("image") != false;
        isText = this._m instanceof DeepwaterMojoModel != false && ((DeepwaterMojoModel)this._m)._problem_type.equals("text") != false;
        for (String dataColumnName : data.keySet()) {
            block28: {
                block27: {
                    index = this._modelColumnNameToIndexMap.get(dataColumnName);
                    if (index == null || index >= rawData.length) continue;
                    img = null;
                    domainValues = this._m.getDomainValues(index);
                    if (domainValues == null) {
                        value = NaN;
                        o = data.get(dataColumnName);
                        if (o instanceof String) {
                            s = ((String)o).trim();
                            if (isImage) {
                                isURL = s.matches("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
                                try {
                                    img = isURL != false ? ImageIO.read(new URL(s)) : ImageIO.read(new File(s));
                                }
                                catch (IOException e) {
                                    throw new PredictException("Couldn't read image from " + s);
                                }
                            } else {
                                if (isText) {
                                    throw new PredictException("MOJO scoring for text classification is not yet implemented.");
                                }
                                try {
                                    value = Double.parseDouble(s);
                                }
                                catch (NumberFormatException nfe) {
                                    if (this._convertInvalidNumbersToNa) ** GOTO lbl39
                                    throw new PredictNumberFormatException("Unable to parse value: " + s + ", from column: " + dataColumnName + ", as Double; " + nfe.getMessage());
                                }
                            }
                        } else if (o instanceof Double) {
                            value = (Double)o;
                        } else if (o instanceof byte[] && isImage) {
                            is = new ByteArrayInputStream((byte[])o);
                            try {
                                img = ImageIO.read(is);
                            }
                            catch (IOException e) {
                                throw new PredictException("Couldn't interpret raw bytes as an image.");
                            }
                        } else {
                            throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for numeric column " + dataColumnName);
                        }
lbl39:
                        // 5 sources

                        if (isImage && img != null) {
                            dwm = (DeepwaterMojoModel)this._m;
                            W = dwm._width;
                            H = dwm._height;
                            C = dwm._channels;
                            _destData = new float[W * H * C];
                            try {
                                GenModel.img2pixels(img, W, H, C, _destData, 0, dwm._meanImageData);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                throw new PredictException("Couldn't vectorize image.");
                            }
                            rawData = new double[_destData.length];
                            for (i = 0; i < rawData.length; ++i) {
                                rawData[i] = _destData[i];
                            }
                            return rawData;
                        }
                        if (Double.isNaN(value)) {
                            this._errorConsumer.dataTransformError(dataColumnName, o, "Given non-categorical value is unparseable, treating as NaN.");
                        }
                        rawData[index.intValue()] = value;
                        continue;
                    }
                    o = data.get(dataColumnName);
                    if (!(o instanceof String)) break block27;
                    levelName = (String)o;
                    columnDomainMap = this._domainMap.get(index);
                    levelIndex = columnDomainMap.get(levelName);
                    if (levelIndex == null) {
                        levelIndex = columnDomainMap.get(dataColumnName + "." + levelName);
                    }
                    if (levelIndex != null) ** GOTO lbl74
                    if (this._convertUnknownCategoricalLevelsToNa) {
                        value = NaN;
                        this._errorConsumer.unseenCategorical(dataColumnName, o, "Previously unseen categorical level detected, marking as NaN.");
                    } else {
                        this._errorConsumer.dataTransformError(dataColumnName, o, "Unknown categorical level detected.");
                        throw new PredictUnknownCategoricalLevelException("Unknown categorical level (" + dataColumnName + "," + levelName + ")", dataColumnName, levelName);
lbl74:
                        // 1 sources

                        value = levelIndex.intValue();
                    }
                    break block28;
                }
                if (o instanceof Double && Double.isNaN((Double)o)) {
                    this._errorConsumer.dataTransformError(dataColumnName, o, "Missing factor value detected, setting to NaN");
                    value = (Double)o;
                } else {
                    this._errorConsumer.dataTransformError(dataColumnName, o, "Unknown categorical variable type.");
                    throw new PredictUnknownTypeException("Unexpected object type " + o.getClass().getName() + " for categorical column " + dataColumnName);
                }
            }
            rawData[index.intValue()] = value;
        }
        return rawData;
    }
}

