/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.PredictContributions;
import hex.genmodel.algos.tree.TreeSHAPPredictor;

public abstract class ContributionsPredictor<E>
implements PredictContributions {
    private final int _ncontribs;
    private final TreeSHAPPredictor<E> _treeSHAPPredictor;
    private static ThreadLocal<Object> _workspace = new ThreadLocal();

    public ContributionsPredictor(int ncontribs, TreeSHAPPredictor<E> treeSHAPPredictor) {
        this._ncontribs = ncontribs;
        this._treeSHAPPredictor = treeSHAPPredictor;
    }

    @Override
    public final float[] calculateContributions(double[] input) {
        float[] contribs = new float[this._ncontribs];
        this._treeSHAPPredictor.calculateContributions(this.toInputRow(input), contribs, 0, -1, this.getWorkspace());
        return this.getContribs(contribs);
    }

    protected abstract E toInputRow(double[] var1);

    public float[] getContribs(float[] contribs) {
        return contribs;
    }

    private Object getWorkspace() {
        Object workspace = _workspace.get();
        if (workspace == null) {
            workspace = this._treeSHAPPredictor.makeWorkspace();
            _workspace.set(workspace);
        }
        return workspace;
    }
}

